/**
 *		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dk.kvl.gui.alignment;

import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;
import java.net.URL;
import java.util.*;
import dk.kvl.gui.properties.AlignmentProperties;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    November 18, 2004
 */
public class AlignmentControlPanel extends JPanel implements ActionListener {
  //changes in the text on these buttons should be changed
  //accordingly in AlignmentContainer.actionPerformed()
  //private JButton subAlignmentButton = new JButton("Subalignment");
  //private JButton clearButton = new JButton("Clear selection");
  //private JButton upperCaseButton;
  //private JButton lowerCaseButton;
  //private JButton rotateLeftButton;
  //private JButton rotateRightButton;
  private JButton changeButton;
  //private JButton updateButton = new JButton("Update");
  //private JButton closeButton = new JButton("Close");
  private JButton splitButton = null;
  private JButton unsplitButton = null;
  private JButton pairButton;
  private JButton unpairButton;
  private JButton pairColButton;
  private JButton singleSelectButton;
  private JButton doubleSelectButton;
  private final AlignmentProperties properties;


  /**
   *Constructor for the AlignmentControlPanel object
   *
   * @param  prop         Description of the Parameter
   * @param  columnNames  Description of the Parameter
   */
  public AlignmentControlPanel(AlignmentProperties prop, String[] columnNames) {
    super();
    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    //
    properties = prop;
    //rotate right button
    //Icon rotateRightIcon = new ImageIcon(properties.getIconDir() + "/rotateleft.jpg");
    //rotateRightButton = new JButton(rotateRightIcon);
    //rotateRightButton.getAccessibleContext().setAccessibleName("rotate right");
    //rotateRightButton.setToolTipText("Rotate right by moving trailing gaps to the left - Ctrl+Shift-M");
    //rotateRightButton.setBorder(new EmptyBorder(1, 1, 1, 1));
    //add(rotateRightButton);
    //rotate left button
//    Icon rotateLeftIcon = new ImageIcon(properties.getIconDir() + "/rotateright.jpg");
//    rotateLeftButton = new JButton(rotateLeftIcon);
//    rotateLeftButton.getAccessibleContext().setAccessibleName("rotate left");
//    rotateLeftButton.setToolTipText("Rotate left by moving trailing gaps to the right - Ctrl-M");
//    rotateLeftButton.setBorder(new EmptyBorder(1, 1, 1, 1));
//    add(rotateLeftButton);
    //toUppercase
    //Icon toUpperCaseIcon = new ImageIcon(properties.getIconDir() + "/touppercase.jpg");
    //upperCaseButton = new JButton(toUpperCaseIcon);
//    upperCaseButton.getAccessibleContext().setAccessibleName("uppercase");
//    upperCaseButton.setToolTipText("Change selected, and corresponding, bases to uppercase, indicating pairing - Ctrl-T");
//    upperCaseButton.setBorder(new EmptyBorder(1, 1, 1, 1));
//    upperCaseButton.addActionListener(this);
//    add(upperCaseButton);
    //toLowercase
//    Icon toLowerCaseIcon = new ImageIcon(properties.getIconDir() + "/tolowercase.jpg");
//    lowerCaseButton = new JButton(toLowerCaseIcon);
//    lowerCaseButton.getAccessibleContext().setAccessibleName("lowercase");
//    lowerCaseButton.setToolTipText("Change selected, and corresponding, bases to lowercase, indicating non-pairing - Ctrl+Shift-T");
//    lowerCaseButton.setBorder(new EmptyBorder(1, 1, 1, 1));
//    lowerCaseButton.addActionListener(this);
//    add(lowerCaseButton);
    //pairs
    Icon pairbasesIcon = new ImageIcon(properties.getIconDir() + "/pairbases.jpg");
    pairButton = new JButton(pairbasesIcon);
    pairButton.getAccessibleContext().setAccessibleName("Pair bases");
    pairButton.setToolTipText("Pair selected bases in the selected columns, and make uppercase - Ctrl-B");
    pairButton.setBorder(new EmptyBorder(1, 1, 1, 1));
    add(pairButton);
    //
    Icon unpairbasesIcon = new ImageIcon(properties.getIconDir() + "/unpairbases.jpg");
    unpairButton = new JButton(unpairbasesIcon);
    unpairButton.getAccessibleContext().setAccessibleName("unpair bases");
    unpairButton.setToolTipText("Umpair selected bases in the selected columns, and make lowercase ");
    unpairButton.setBorder(new EmptyBorder(1, 1, 1, 1));
    add(unpairButton);
    //pairs
    Icon paircolIcon = new ImageIcon(properties.getIconDir() + "/paircolumns.jpg");
    pairColButton = new JButton(paircolIcon);
    pairColButton.getAccessibleContext().setAccessibleName("Pair columns");
    pairColButton.setToolTipText("Pair all matching bases in the selected columns - Ctrl-K");
    pairColButton.setBorder(new EmptyBorder(1, 1, 1, 1));
    add(pairColButton);
    //change
    Icon changeIcon = new ImageIcon(properties.getIconDir() + "/change.jpg");
    changeButton = new JButton(changeIcon);
    changeButton.getAccessibleContext().setAccessibleName("change");
    changeButton.setToolTipText("Change the symbol to any symbol in the alphabet - Alt-T");
    changeButton.setBorder(new EmptyBorder(1, 1, 1, 1));
    changeButton.addActionListener(this);
    add(changeButton);
    //split
    Icon splitIcon = new ImageIcon(properties.getIconDir() + "/split.jpg");
    splitButton = new JButton(splitIcon);
    splitButton.getAccessibleContext().setAccessibleName("split");
    splitButton.setToolTipText("Splits the view - Ctrl-I");
    splitButton.setBorder(new EmptyBorder(1, 1, 1, 1));
    splitButton.addActionListener(this);
    add(splitButton);
    //unsplit
    Icon unsplitIcon = new ImageIcon(properties.getIconDir() + "/unsplit.jpg");
    unsplitButton = new JButton(unsplitIcon);
    unsplitButton.getAccessibleContext().setAccessibleName("unsplit");
    unsplitButton.setToolTipText("Unsplits the view - Ctrl+Shift-I");
    unsplitButton.setBorder(new EmptyBorder(1, 1, 1, 1));
    unsplitButton.addActionListener(this);
    unsplitButton.setEnabled(false);
    add(unsplitButton);
    
    Icon singleIcon = new ImageIcon(properties.getIconDir() + "/singleselect.jpg");
    singleSelectButton = new JButton(singleIcon);
    singleSelectButton.getAccessibleContext().setAccessibleName("single");
    singleSelectButton.setToolTipText("Activates Single Select Mode");
    singleSelectButton.setBorder(new EmptyBorder(1, 1, 1, 1));
    singleSelectButton.addActionListener(this);
    singleSelectButton.setEnabled(true);
    add(singleSelectButton);
    
    Icon doubleIcon = new ImageIcon(properties.getIconDir() + "/doubleselect.jpg");
    doubleSelectButton = new JButton(doubleIcon);
    doubleSelectButton.getAccessibleContext().setAccessibleName("double");
    doubleSelectButton.setToolTipText("Activates Double Select Mode");
    doubleSelectButton.setBorder(new EmptyBorder(1, 1, 1, 1));
    doubleSelectButton.addActionListener(this);
    doubleSelectButton.setEnabled(false);
    add(doubleSelectButton);
    
    //
    //add(subAlignmentButton);
    //add(clearButton);
    //add(updateButton);
    //add(closeButton);
  }


  /**
   *  Adds a feature to the ActionListener attribute of the AlignmentControlPanel object
   *
   * @param  listener  The feature to be added to the ActionListener attribute
   */
  public void addActionListener(ActionListener listener) {
    //subAlignmentButton.addActionListener(listener);
    //clearButton.addActionListener(listener);
    splitButton.addActionListener(listener);
    unsplitButton.addActionListener(listener);
    //upperCaseButton.addActionListener(listener);
    //lowerCaseButton.addActionListener(listener);
    //rotateLeftButton.addActionListener(listener);
    //rotateRightButton.addActionListener(listener);
    changeButton.addActionListener(listener);
    pairButton.addActionListener(listener);
    unpairButton.addActionListener(listener);
    pairColButton.addActionListener(listener);
    singleSelectButton.addActionListener(listener);
    doubleSelectButton.addActionListener(listener);
    //updateButton.addActionListener(listener);
    //closeButton.addActionListener(listener);
  }



  /**
   *  Description of the Method
   *
   * @param  ae  Description of the Parameter
   */
  public void actionPerformed(ActionEvent ae) {
    if ((((JButton) ae.getSource())).getAccessibleContext().getAccessibleName().equals("split")) {
      unsplitButton.setEnabled(true);
      splitButton.setEnabled(false);
    } else {
      if ((((JButton) ae.getSource())).getAccessibleContext().getAccessibleName().equals("unsplit")) {
        unsplitButton.setEnabled(false);
        splitButton.setEnabled(true);
      }
    }
    if ((((JButton) ae.getSource())).getAccessibleContext().getAccessibleName().equals("single")) {
      doubleSelectButton.setEnabled(true);
      singleSelectButton.setEnabled(false);
    } else {
      if ((((JButton) ae.getSource())).getAccessibleContext().getAccessibleName().equals("double")) {
        doubleSelectButton.setEnabled(false);
        singleSelectButton.setEnabled(true);
      }
    }
  }


  /**
   *  Description of the Method
   *
   * @param  split  Description of the Parameter
   */
  public void enableSplitButtons(boolean split) {
    if (split) {
      splitButton.setEnabled(false);
      unsplitButton.setEnabled(true);
    } else {
      unsplitButton.setEnabled(false);
      splitButton.setEnabled(true);
    }
  }
  
  
}


