/*		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package dk.kvl.gui.alignment.table;

import javax.swing.border.*;
import dk.kvl.gui.properties.*;
import java.awt.*;

public class AlignmentBorder extends EmptyBorder
{
    private final AlignmentProperties properties;

    public AlignmentBorder(AlignmentProperties ap)throws Exception
    {
	super(1,1,1,1);
	if(ap == null)
	    {
		throw new Exception("null not allowed for properties");
 	    }
	properties = ap;
    }

    public boolean isOpaque()
    {
	return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
    {
	g.setColor(properties.getBackground());
	super.paintBorder(c,g,x,y,width,height);
    }
}
