/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.gui.alignment.table;

import javax.swing.table.*;
import dk.kvl.alignmenttools.*;
import dk.kvl.sequencetools.*;
import dk.kvl.controller.*;
import java.awt.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    January 20, 2004
 */
public class AlignmentDataModel extends AbstractTableModel
{
    private AlignmentController alignmentController = null;
    private String name;
    private TitleTable sequenceNames;
    
    /**
     *  Constructor for the AlignmentDataModel object
     *
     * @param  align  Description of the Parameter
     */
    public AlignmentDataModel(AlignmentController align, String name, TitleTable names)
    {
        sequenceNames = names;
        alignmentController = align;
        this.name = name;
    }


    /**
     *  Gets the columnName attribute of the AlignmentDataModel object
     *
     * @param  col  Description of the Parameter
     * @return      The columnName value
     */
    public String getColumnName(int col)
    {
        //col += alignmentController.getStartIndex(name);
        return "" + (col + 1);
    }


    /**
     *  Gets the rowCount attribute of the AlignmentDataModel object
     *
     * @return    The rowCount value
     */
    public int getRowCount()
    {
        if(alignmentController.getPairingmask() != null)
        {
        return alignmentController.getTotalNumberOfSequences(name);
        }
        else
        {
            return alignmentController.getNumberOfSequences();
        }
    }


    /**
     *  Gets the columnCount attribute of the AlignmentDataModel object
     *
     * @return    The columnCount value
     */
    public int getColumnCount()
    {
        return alignmentController.getAlignmentLength();
    }
    /**
     *  Gets the valueAt attribute of the AlignmentDataModel object
     *
     * @param  row  Description of the Parameter
     * @param  col  Description of the Parameter
     * @return      The valueAt value
     */
    public Object getValueAt(int row, int col)
    {
        String sequenceName = sequenceNames.getSequenceName(row);
        return ""+alignmentController.getCharAt(sequenceName, col);
    }


    /**
     *  Gets the cellEditable attribute of the AlignmentDataModel object
     *
     * @param  row  Description of the Parameter
     * @param  col  Description of the Parameter
     * @return      The cellEditable value
     */
    public boolean isCellEditable(int row, int col)
    {
        return false;
    }
    
   

    /**
     *  Sets the valueAt attribute of the AlignmentDataModel object
     *
     * @param  value  The new valueAt value
     * @param  row    The new valueAt value
     * @param  col    The new valueAt value
     */
    public void setValueAt(Object value, int row, int col)
    {
      String[] names = new String[]{getSequenceName(row)};
      char val = ((String)value).charAt(0);
      alignmentController.changeSymbols(names,new int[]{col},val);
    }

    public String getSequenceName(int row)
    {
        return sequenceNames.getSequenceName(row);
    }
    
    public Color getBackground(int row, int column)
    {
        return alignmentController.getBackground(getSequenceName(row),column);
    }

    public Color getForeground(int row, int column)
    {
        return alignmentController.getForeground(getSequenceName(row),column);
    }
    
}

