/**
 *		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dk.kvl.gui.alignment.table;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;
import java.awt.*;
import dk.kvl.alignmenttools.*;
import dk.kvl.gui.properties.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    October 27, 2004
 */
public class SmallHeader extends JLabel implements TableCellRenderer {
	private Alignment alignment;

	private AlignmentProperties properties;

	/**
	 *Constructor for the SmallHeader object
	 *
	 * @param  align  Description of the Parameter
	 * @param  prop   Description of the Parameter
	 */
	public SmallHeader(Alignment align, AlignmentProperties prop) {
		setOpaque(true);
		if (properties == null) {
			setBorder(new EmptyBorder(1, 1, 1, 1));
		} else {
			try {
				setBorder(new AlignmentBorder(properties));
			} catch (Exception e) {
				setBorder(new EmptyBorder(1, 1, 1, 1));
			}
		}
		setVerticalAlignment(SwingConstants.CENTER);
		setHorizontalAlignment(SwingConstants.CENTER);
		properties = prop;
		setFont(properties.getTableFont());
		alignment = align;
	}

	/**
	 *  Gets the tableCellRendererComponent attribute of the SmallHeader object
	 *
	 * @param  table       Description of the Parameter
	 * @param  title       Description of the Parameter
	 * @param  isSelected  Description of the Parameter
	 * @param  hasFocus    Description of the Parameter
	 * @param  row         Description of the Parameter
	 * @param  column      Description of the Parameter
	 * @return             The tableCellRendererComponent value
	 */
	public Component getTableCellRendererComponent(JTable table, Object title,
			boolean isSelected, boolean hasFocus, int row, int column) {
		String txt = "";
		String pair = "<br>&nbsp;";
		setFont(properties.getTableFont());
		//setHorizontalTextPosition(SwingConstants.CENTER);
		table.setBackground(properties.getBackground());
		table.setForeground(properties.getSequenceColor());
		if (row == -1) {
			if (table.getColumnCount() == 1) {

				txt = "&nbsp;<br>&nbsp;";
				if(alignment.getPairingMask() != null){
					txt=txt+"<br>&nbsp";
				}

			} else {
				if ((column + 1) % 5 == 0) {
					pair = "<br>|";
				}
				

					if (column == 0) {
						txt = " 1" + pair;
					} else {
						int col = column + 1;
						String s = null;
						if ((col + 1) % 10 == 0) {
							s = String.valueOf(col + 1);
							txt = " "
									+ s.substring(s.length() - 2,
											s.length() - 1) + pair;
						} else {
							if ((col + 2) % 10 == 0 && col + 2 >= 100) {
								s = String.valueOf(col + 2);
								txt = " "
										+ s.substring(s.length() - 3, s
												.length() - 2) + pair;
							} else {
								if ((col + 3) % 10 == 0 && col + 3 >= 1000) {
									s = String.valueOf(col + 3);
									txt = " "
											+ s.substring(s.length() - 4, s
													.length() - 3) + pair;
								} else {
									if ((col + 4) % 10 == 0 && col + 4 >= 10000) {
										s = String.valueOf(col + 4);
										txt = " "
												+ s.substring(s.length() - 5, s
														.length() - 4) + pair;
									} else {
										if (col % 10 == 0) {
											s = String.valueOf(col);
											txt = " "
													+ s.substring(
															s.length() - 1, s
																	.length())
													+ pair;
										} else {
											txt = pair;
										}
									}
								}
							}
						}
					}
					if (alignment.getPairingMask() != null) {
						String symbol = String.valueOf(alignment.getPairingMask()
								.getSymbolAt(column));
						if(symbol.equals("<")){
							symbol = "&lt;";
						}
						txt = txt+"<br> "+symbol;

					}
				}
			}
		
		setText("<html>" + txt + "</html>");
		return this;
	}
}
