/*		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package dk.kvl.gui.alignment.table;

import javax.swing.*;
import java.awt.*;
import javax.swing.table.*;
import dk.kvl.controller.*;
import dk.kvl.alignmenttools.*;
import java.util.*;
import dk.kvl.gui.properties.*;

public class TitleTable extends JTable
{
    private AlignmentController controller;
    private String alignName;
    private Object[][] names= null;
    private AlignmentProperties properties;
    private int maximumWidth = -1;
    
    public TitleTable(AlignmentController controller, String alignName, AlignmentProperties prop)
    {
        this.controller = controller;
        this.alignName = alignName;
        setDragEnabled(true);
        properties = prop;
        Object[] title = {""};	
        setIntercellSpacing(new Dimension(0, 0));
        setModel(new DefaultTableModel(getSequenceNames(),title));
        
        getTableHeader().setDefaultRenderer(new SmallHeader(controller.getMainAlignment(),prop));
        getTableHeader().setReorderingAllowed(false);
        getTableHeader().setResizingAllowed(false);
        //setBackground(properties.getBackground());
    }
    
    protected Object[][] getSequenceNames()
    {
	String[] sortedNames = controller.getSortedNames();
	if(controller.getPairingmaskName() != null)
	    {
		names = new String[sortedNames.length+1][1];
		names[0][0] = controller.getPairingmaskName();
		for(int i = 0;i<sortedNames.length;i++)
		    {
			names[i+1][0] = sortedNames[i];
		    }
	    }
	else
	    {
		names = new String[sortedNames.length][1];
		for(int i = 0;i<sortedNames.length;i++)
		    {
                
			names[i][0] = sortedNames[i];
		    }

	    }
        return names;
    }
    
    public String getSequenceName(int row)
    {
        //System.out.println(row+"names:"+names.length);
    	return (String)names[row][0];
    }
        
    public Collection getSelectedNames()
    {
        int[] names = getSelectedRows();
        Vector v = new Vector();
        for(int i = 0;i<names.length;i++)
        {
            v.add(getSequenceName(names[i]));
        }
        return v;
    }
    
    public int getMaximumWidth()
    {
        Enumeration keys = controller.getSequenceKeys();
        FontMetrics fm = getAccessibleContext().getAccessibleComponent().getFontMetrics(properties.getTableFont());
        while(keys.hasMoreElements())
        {
          String name = (String)keys.nextElement();
          if(maximumWidth < fm.stringWidth(name))
          {
            maximumWidth = fm.stringWidth(name);
          }
        }
      
      
      return maximumWidth;
    }
    
}
