/**
 *		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dk.kvl.gui.components;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.util.*;
import dk.kvl.controller.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    November 15, 2004
 */
public class AlignmentCanvas extends JPanel implements MouseListener {
  private AlignmentController controller;
  private Vector mouseListeners = new Vector();
  private int zoom = 2;
  private Frame owner;


  /**
   *Constructor for the AlignmentCanvas object
   *
   * @param  owner        Description of the Parameter
   * @param  aController  Description of the Parameter
   */
  public AlignmentCanvas(Frame owner, AlignmentController aController) {
    controller = aController;
    super.addMouseListener(this);
    this.owner = owner;
    setZoom(zoom);
  }


  /**
   *  Description of the Method
   *
   * @param  g  Description of the Parameter
   */
  public void paint(Graphics g) {
    super.paint(g);
    Color bColor;
    String[] sequences = controller.getSortedNames();
    for (int i = 0; i < sequences.length; i++) {
      for (int j = 0; j < controller.getAlignmentLength(); j++) {
        bColor = controller.getBackground(sequences[i], j);
        g.setColor(bColor);
        g.fillRect(j * zoom, i * zoom, zoom, zoom);
      }
    }
  }


  /**
   *  Sets the zoom attribute of the AlignmentCanvas object
   *
   * @param  newZoom  The new zoom value
   */
  public void setZoom(int newZoom) {
    if (newZoom > 0) {
      zoom = newZoom;
      setPreferredSize(new Dimension(controller.getAlignmentLength() * zoom, controller.getNumberOfSequences() * zoom));
      revalidate();
      repaint();
    }
  }


  /**
   *  Gets the zoom attribute of the AlignmentCanvas object
   *
   * @return    The zoom value
   */
  public int getZoom() {
    return zoom;
  }


  /**
   *  Description of the Method
   */
  public void adjustZoom() {
    int width = owner.getWidth() / controller.getAlignmentLength();
    setZoom(Math.max(width, 1));
  }


  /**
   *  Adds a feature to the MouseListener attribute of the AlignmentCanvas object
   *
   * @param  listener  The feature to be added to the MouseListener attribute
   */
  public void addMouseListener(MouseListener listener) {
    mouseListeners.add(listener);
  }


  /**
   *  Description of the Method
   *
   * @param  listener  Description of the Parameter
   */
  public void removeMouseListener(MouseListener listener) {
    mouseListeners.remove(listener);
  }


  /**
   *  Description of the Method
   *
   * @param  e  Description of the Parameter
   */
  public void mouseClicked(MouseEvent e) {
    MouseEvent newEvent = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX() / zoom, e.getY() / zoom, e.getClickCount(), e.isPopupTrigger());
    e.consume();
    for (int i = 0; i < mouseListeners.size(); i++) {
      ((MouseListener) mouseListeners.get(i)).mouseClicked(newEvent);
    }

  }


  /**
   *  Description of the Method
   *
   * @param  e  Description of the Parameter
   */
  public void mouseEntered(MouseEvent e) { }


  /**
   *  Description of the Method
   *
   * @param  e  Description of the Parameter
   */
  public void mouseExited(MouseEvent e) { }


  /**
   *  Description of the Method
   *
   * @param  e  Description of the Parameter
   */
  public void mousePressed(MouseEvent e) { }


  /**
   *  Description of the Method
   *
   * @param  e  Description of the Parameter
   */
  public void mouseReleased(MouseEvent e) { }
  

}

