/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.gui.components;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class DependingTextFields extends JPanel implements CaretListener
{
    private JTextField field1;
    private JTextField field2;
    private String default1;
    private String default2;
    private OkCancelPanel ocPanel;
    
    public DependingTextFields(String text, String name1, String name2, String value1, String value2, ActionListener listener)
    {
        super(new BorderLayout());
        JLabel label = new JLabel(text);
        JLabel title1 = new JLabel(name1);
        JLabel title2 = new JLabel(name2);
        default1 = value1;
        default2 = value2;
        field1 = new JTextField(value1);
        field2 = new JTextField(value2);
	JPanel browsePanel = new JPanel();
	JButton browse = new JButton("Browse");
	browse.addActionListener(listener);
	browsePanel.add(field2);
	browsePanel.add(browse);
        //field2.setEditable(false);
        //field1.addCaretListener(this);
        add(BorderLayout.NORTH, label);
        JPanel fieldPanel = new JPanel(new BorderLayout());
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add(BorderLayout.WEST, title1);
        panel1.add(BorderLayout.CENTER, field1);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add(BorderLayout.WEST, title2);
        panel2.add(BorderLayout.CENTER, browsePanel);
        fieldPanel.add(BorderLayout.SOUTH, panel2);
        fieldPanel.add(BorderLayout.NORTH, panel1);
        add(BorderLayout.CENTER,fieldPanel);
        ocPanel = new OkCancelPanel(listener);
        add(BorderLayout.SOUTH, ocPanel);
    }
    
    public void caretUpdate(CaretEvent ce)
    {
        field2.setText(default2);//+field1.getText());
    }

    public String getValue1()
    {
        return field1.getText();
    }
    
    public String getValue2()
    {
        return field2.getText();
    }
    
    public JTextField getField1(){
	return field1;
    }
    
    public JTextField getField2(){
	return field2;
    }
    
    public void removeActionListener(ActionListener listener)
    {
        ocPanel.removeActionListener(listener);
    }
    
    public void setDir(String path)
    {
      default2 = path+"/";
      field2.setText(default2);//+field1.getText());
    }
}
