package dk.kvl.gui.components;

import javax.swing.*;
import javax.swing.tree.*;
import java.awt.*;
import java.util.*;
import dk.kvl.tools.*;
import dk.kvl.gui.properties.*;

public class HistoryTreeRenderer extends JLabel implements TreeCellRenderer
{
    private String fileName;
    private History history;
    private boolean isShownParent;
    private String txt;
    private int changeColor;
    private DefaultMutableTreeNode root;
    private AlignmentProperties properties;
    
    public HistoryTreeRenderer(String fileName, History history, DefaultMutableTreeNode root, AlignmentProperties properties){
      super();
      this.fileName = fileName;
      this.history = history;
      this.root = root;
      this.properties = properties; 
      setOpaque(true);
    }
    
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus){
	txt = value.toString();
  //System.out.println("History font: "+getFont().toString());
  setFont(properties.getTableFont());
	setText(txt);
	if (!txt.equals("Files in project")){
	    setFont(getFont().deriveFont(Font.ITALIC));
	}
	else{
	    setFont(getFont().deriveFont(Font.PLAIN));
	}
	if (txt.equals(fileName)){
	    isShownParent = true;
	}
	else{
	    isShownParent = false;
	}
	Enumeration e = root.children();
	while (e.hasMoreElements()){
	    DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
	    Enumeration enumeration = node.children();
	    while (enumeration.hasMoreElements()){
		DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
		if (child.equals((DefaultMutableTreeNode)value)){
		    int childIndex = node.getIndex(child);
		    int hisIndex = 0;
		    if (history.getUndone()){
			hisIndex = history.getPosition();
		    }
		    else{
			hisIndex = history.getIndex();
		    }
		    if (childIndex < hisIndex){
			setFont(getFont().deriveFont(Font.PLAIN));
		    }
		    else{
			if (childIndex > hisIndex){
			    setFont(getFont().deriveFont(Font.ITALIC));
			}
			else{
			    if (childIndex == hisIndex){
				if (history.getUndone()){
				    setFont(getFont().deriveFont(Font.ITALIC));
				}
				else{
				    setFont(getFont().deriveFont(Font.PLAIN));
				}
			    }
			}
		    }
		}
	    }
	}
	if (((DefaultMutableTreeNode)value).getDepth() == 1){
	    setFont(getFont().deriveFont(Font.PLAIN));
	}
	setIcon(null);
	
	return this;
    }
    
    public void paint( Graphics g ){
	Color bColor;
	// Set the correct background colour
	if (isShownParent){
	    bColor = Color.lightGray;
	}
	/*else{
	    if (changeColor == 1){
		bColor = Color.red;
	    }
	    else{
		if (changeColor == 2){
		    bColor = Color.blue;
		}*/
		else{
		    bColor = Color.white;
		}
	    /*}
	}*/
        g.setColor(bColor);

        // Draw a rectangle in the background of the cell
        g.fillRect( 0, 0, getWidth() - 1, getHeight() - 1 );
	
	/*if (txt != null){
	    if (changeColor == 1){
		bColor = Color.red;
	    }
	    else{
		if (changeColor == 2){
		    bColor = Color.blue;
		}
		else{
		    bColor = Color.black;
		}
	    }
	}
	g.setColor(bColor);
	g.drawString(txt, 0, 0);*/
	changeColor = 0;

        super.paint(g);
    }

    public void setFileName(String fileName){
	this.fileName = fileName;
    }
    
    public void setHistory(History history){
	this.history = history;
    }
}
