/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.gui.properties;

import java.util.*;
import java.io.*;

public class ProjectProperties extends Properties
{
    private String header = "This file was created automatically, and should not be manually edited";    
    
    public ProjectProperties(String name, String file, String path)
    {
        setName(name);
        setFile(file);
        setPath(path);
    }    
    
    public ProjectProperties(String name, String file)
    {
        setName(name);
        setFile(file);
    }
    
    public ProjectProperties(String fileName)throws IOException
    {
        load(fileName);
    }
    
    public void setName(String name)
    {
        setProperty("name",name);
    }

    public void setFile(String file)
    {
        setProperty("file",file);
    }
    
    public void setPath(String path){
	setProperty("path", path);
    }
    
    public void load(String name)throws IOException
    {
        load(new FileInputStream(AlignmentProperties.getProjectDir()+"/"+name));
    }
    
    public String getName()
    {
        return getProperty("name");
    }
    
    public String getFile(){
	return getProperty("file");
    }
    
    public String getPath(){
	return getProperty("path");
    }
    
    public void store() throws IOException, FileNotFoundException
    {
	File f = new File(AlignmentProperties.getProjectDir()+"/"+getName()+".prj");
	FileOutputStream fos = new FileOutputStream(f);
	store(fos,header);
	fos.close();
    }
}
