/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.gui.properties;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import dk.kvl.gui.tools.*;
import dk.kvl.gui.components.*;
import dk.kvl.controller.*;
import dk.kvl.gui.event.*;
import java.util.*;
import java.io.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    January 21, 2004
 */
public class PropertyFrame extends JFrame implements ActionListener
{
    private JTabbedPane content = new JTabbedPane();
    private JPanel tableAppearance = new JPanel(new BorderLayout());
    private AlignmentProperties properties = null;
    private JButton aColorButton = null;
    private JButton uColorButton = null;
    private JButton cColorButton = null;
    private JButton gColorButton = null;
    private Vector updateListeners = new Vector();
    

    /**
     *  Constructor for the PropertyFrame object
     *
     * @param  startProperties  Description of the Parameter
     */
    public PropertyFrame(AlignmentProperties startProperties)
    {
        super("Properties");
        properties = startProperties;
        setLocation(300, 300);
        tableAppearanceSettings();
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        setSize(400, 400);
        content.addTab("Appearance", tableAppearance);
        try
        {
	    // content.add("programs",new ProgramPanel(properties));
        }
        catch(Exception e)
        {
            JOptionPane.showMessageDialog(null, e.getMessage());
            e.printStackTrace();
        }
        getContentPane().add(content);
        setVisible(true);
    }


    /**
     *  Description of the Method
     */
    public void tableAppearanceSettings()
    {
        JLabel title = new JLabel("Appearance of Tables");
        JPanel titleHolder = new JPanel();
        titleHolder.add(title);
        //
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.Y_AXIS));
        //colorbuttons
        aColorButton = new JButton("Change color for base: A");
        aColorButton.setForeground(properties.getAColor());
        aColorButton.addActionListener(this);
        buttonPanel.add(aColorButton);
        uColorButton = new JButton("Change color for base: U");
        uColorButton.setForeground(properties.getUColor());
        uColorButton.addActionListener(this);
        buttonPanel.add(uColorButton);
        cColorButton = new JButton("Change color for base: C");
        cColorButton.setForeground(properties.getCColor());
        cColorButton.addActionListener(this);
        buttonPanel.add(cColorButton);
        gColorButton = new JButton("Change color for base: G");
        gColorButton.setForeground(properties.getGColor());
        gColorButton.addActionListener(this);
        buttonPanel.add(gColorButton);
        //enable coloring
        final JCheckBox enableBox = new JCheckBox("Enable basecoloring", properties.isBaseColoringEnabled());
        enableBox.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    properties.setBaseColoring(enableBox.isSelected());
                }
            });
        buttonPanel.add(enableBox);

        //
        tableAppearance.add(BorderLayout.SOUTH, new OkCancelPanel(this));
        tableAppearance.add(BorderLayout.WEST, buttonPanel);
        tableAppearance.add(BorderLayout.NORTH, titleHolder);
    }


    /**
     *  Description of the Method
     *
     * @param  ae  Description of the Parameter
     */
    public void actionPerformed(ActionEvent ae)
    {
        String event = ae.getActionCommand();
        if (event.equals("OK"))
        {
            fireUpdateEvent();
            dispose();
        }
        else if (event.equals("Cancel"))
        {
            
            dispose();
        }
        else
        {
            Component comp = (Component)ae.getSource();
            Color color = JColorChooser.showDialog(this, "Choose new color", comp.getForeground());
            if (color != null && !color.equals(comp.getForeground()))
            {
                if (event.equals("Change color for base: A"))
                {
                    properties.setAColor(color);
                    aColorButton.setForeground(color);
                }
                else if (event.equals("Change color for base: U"))
                {
                    properties.setUColor(color);
                    uColorButton.setForeground(color);
                }
                else if (event.equals("Change color for base: C"))
                {
                    properties.setCColor(color);
                    cColorButton.setForeground(color);
                }
                else if (event.equals("Change color for base: G"))
                {
                    properties.setGColor(color);
                    gColorButton.setForeground(color);
                }
            }
        }
    }
    
    public void addUpdateListener(UpdateListener ul)
    {
        updateListeners.add(ul);
    }
    
    public void fireUpdateEvent()
    {
        UpdateEvent ue = new UpdateEvent(this, 1, "updated");
        for(int i=0;i<updateListeners.size();i++)
        {
            ((UpdateListener)updateListeners.get(i)).updatePerformed(ue);
        }
    }
}

