/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.gui.tools;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.color.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    January 19, 2004
 */
public class FontChooser extends JDialog
{
    private Font oldFont = null;
    private JComboBox fontChooser = null;
    private JTextField size = null;
    //not the best way for sure
    private static Font newFont = null;     
    /**
     *  Constructor for the FontChooser object
     *
     * @param  owner    Description of the Parameter
     * @param  oldFont  Description of the Parameter
     */
    public FontChooser(JFrame owner, Font oldFont)
    {
        super(owner, "Define your font");
        getContentPane().setLayout(new BorderLayout());
        this.oldFont = oldFont;
        newFont = oldFont;
        arrangeComponents();
        setLocation(350,350);
        setSize(300, 200);
        setVisible(true);
    }


    /**
     *  Description of the Method
     */
    protected void arrangeComponents()
    {
        //header
        JLabel header = new JLabel("Choose font, size and color");
        getContentPane().add(BorderLayout.NORTH, header);
        //
        JPanel selectPanel = new JPanel(new GridLayout(2,1));
        //labels
        JLabel fontLabel = new JLabel("Font: ");
        JLabel sizeLabel = new JLabel("Size: ");
        //
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
         fontChooser = new JComboBox(fonts);
        //
        size = new JTextField("" + oldFont.getSize(), 2);
        //div panels
        JPanel p1 = new JPanel(new FlowLayout(FlowLayout.LEFT));
        JPanel p2 = new JPanel(new FlowLayout(FlowLayout.LEFT));
        //
        p1.add(fontLabel);
        p1.add(fontChooser);
        p2.add(sizeLabel);
        p2.add(size);
        //
        selectPanel.add(p1);
        selectPanel.add(p2);
        //okCancelPanel
        JPanel okCancelPanel = new JPanel();
        JButton okButton = new JButton("OK");
        okButton.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    okButtonPressed();
                }
            });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(
            new ActionListener()
            {
                public void actionPerformed(ActionEvent ae)
                {
                    cancelButtonPressed();
                }
            });
        okCancelPanel.add(okButton);
        okCancelPanel.add(cancelButton);
        //arranging
        getContentPane().add(BorderLayout.SOUTH, okCancelPanel);
        getContentPane().add(BorderLayout.CENTER, selectPanel);        
    }


    /**
     *  Description of the Method
     */
    public void okButtonPressed()
    {
        try
        {
        int textSize = Integer.parseInt(size.getText());
        newFont = new Font((String)fontChooser.getSelectedItem(),Font.PLAIN,textSize);
        
        }
        catch(Exception e)
        {
            JOptionPane.showMessageDialog(this, "Illigal font definition, try again");
        }
    }


    /**
     *  Description of the Method
     */
    public void cancelButtonPressed()
    {
        dispose();
    }
    
    public void colorButtonPressed()
    {
        Color color = JColorChooser.showDialog(this,"Choose color",Color.BLACK);
    }
    
    public static Font getNewFont()
    {
        return newFont;
    }
}


