package dk.kvl.sequencetools;

import java.io.Serializable;

public class PairingmaskAlphabet implements SequenceAlphabet,Serializable {

	private char[] alphabet = {};
    private final String label = "pairingmask";
    private final int alphabetType = SequenceAlphabet.PAIRINGMASK;

    /**
     *  Gets the RNA alphabet
     *
     * @return    The alphabet
     */
    public char[] getAlphabet()
    {
        return alphabet;
    }


    /**
     *  Examines the sequence to see if it is valid It searches until it finds
     *  the first invalid character
     *
     * @param  sequence  Description of the Parameter
     * @return           The validSequence value
     */
    public boolean isValidSequence(String sequence)
    {
        return true;
    }


    /**
     *  Gets the label attribute of the RNAAlphabet object
     *
     * @return    The label value
     */
    public String getLabel()
    {
        return label;
    }
    
    public int getAlphabetType()
    {
        return alphabetType;   
    }
    
    public boolean isValidSymbol(char aChar)
    {
        return true;
    }
    
    public boolean isPairing(char symbol1, char symbol2)
    {
        return true;
    }
}
