/**
 *  SARSE, Semi-Automated RNA Sequence Editor. Copyright (C) 2004 Allan
 *  Lind-Thomsen This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version. This program is distributed in the hope that it
 *  will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 *  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *  Public License for more details. You should have received a copy of the GNU
 *  General Public License along with this program; if not, write to the Free
 *  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 *  02111-1307, USA.
 */
package dk.kvl.tools;

import java.io.*;

/**
 *  Description of the Class
 *
 * @author     allanAllan
 * @created    January 8, 2004
 */
public class StringTools
{
    /**
     *  Splits a string i two by the 1 char of type 'split' It is used to split
     *  a string when the 2 parts is seperated by a series af spaces
     *
     * @param  source  the source string
     * @param  split   The split charactor
     * @return         A String[] length = 2, or null if source = null og empty.
     */
    public static String[] split(String source, char split)
    {
        source = source.trim();
        if (source == null || source.equals(""))
        {
            return null;
        }
        String[] result = new String[2];
        String[] tmpResult = source.split(String.valueOf(split));
        //The relevant substrings are the first and the last, in between there should only be spaces
        result[0] = tmpResult[0];
        if (tmpResult.length > 1)
        {
            result[1] = tmpResult[tmpResult.length - 1];
        }
        return result;
    }


    /**
     *  Description of the Method
     *
     * @param  text  Description of the Parameter
     * @return       Description of the Return Value
     */
    public static Character[] stringToCharacterArray(String text)
    {
        Character[] array = new Character[text.length()];
        for (int i = 0; i < text.length(); i++)
        {
            array[i] = new Character(text.charAt(i));
        }
        return array;
    }


    /**
     *  Description of the Method
     *
     * @param  first  Description of the Parameter
     * @param  last   Description of the Parameter
     * @return        Description of the Return Value
     */
    public static int[] combineArrays(int[] first, int[] last)
    {
        int[] newArray = new int[first.length + last.length];
        System.arraycopy(first, 0, newArray, 0, first.length);
        System.arraycopy(last, 0, newArray, first.length, last.length);
        return newArray;
    }
    
    public static int[] reverseArray(int[] array)
    {
        int[] newArray = new int[array.length];
            for(int i = 0;i<array.length;i++)
            {
                newArray[i] = array[array.length-1-i];
            }
            return newArray;
    }


    /**
     *  combine 2 sorted arrays, ascending or descending order with no douplets, and keeps the return the result sorted in ascending order
     *  if the same value exists in both arrays only one is kept
     *  
     * @param  first  Description of the Parameter
     * @param  last   Description of the Parameter
     * @return        Description of the Return Value
     */
    public static int[] combineSortedArrays(int[] first, int[] last)
    {
        int[] newArray = new int[first.length + last.length];
        //check for descending order
        if(first.length > 1 && first[0] > first[1])
        {
            first = reverseArray(first);
        }
        if(last.length > 1 && last[0] > last[1])
        {
            last = reverseArray(last);
        }
        //check for empty arrays
        if(last.length == 0 && first.length == 0)
        {
            newArray = last;
        }
        else if(last.length == 0)
        {
            newArray = first;
        }
        else if(first.length == 0)
        {
            newArray = last;
        }
        else
        {
            //combine 2 non-empty arrays
            int i;
            int lastCounter = 0;
            int firstCounter = 0;
            boolean firstOut = false;
            boolean lastOut = false;
            IntArray tmpArray = new IntArray(first.length+last.length); 
            for(i = 0; i<newArray.length;i++)
            {
                if(first[firstCounter]<last[lastCounter])
                {
                    tmpArray.add(first[firstCounter]);
                    firstCounter++;
                    if(firstCounter == first.length)
                    {
                        firstOut = true;
                        break;
                    }
                }
                else if (first[firstCounter]>last[lastCounter])
                {
                    tmpArray.add(last[lastCounter]);
                    lastCounter++;
                    if(lastCounter == last.length)
                    {
                        lastOut = true;
                        break;
                    }
                }
                else//equality
                {
                    tmpArray.add(last[lastCounter]);
                    lastCounter++;
                    firstCounter++;
                    if(lastCounter == last.length && firstCounter == first.length)
                    {
                        firstOut = true;  
                        lastOut = true;
                        break;
                    }
                    else if(lastCounter == last.length)
                    {
                        lastOut = true;
                        break;
                    }
                    else if(firstCounter == first.length)
                    {
                        firstOut = true;
                        break;
                    }
                }
            }
            //copy the rest of the unfinished array
            if(firstOut && lastOut)
            {
                //no action
            }
            else if(firstOut)
            {
                //copy rest of last
                for(int j = lastCounter;j<last.length;j++)
                {
                    tmpArray.add(last[j]);
                }
            }
            else if(lastOut)
            {
                //copy rest of first
                for(int j = firstCounter;j<first.length;j++)
                {
                    tmpArray.add(first[j]);
                }
            }
            newArray = tmpArray.toArray();
        }
        return newArray;
    }



    /**
     *  Description of the Method
     *
     * @param  inFile           Description of the Parameter
     * @param  outFile          Description of the Parameter
     * @param  bRemoveSource    Description of the Parameter
     * @exception  IOException  Description of the Exception
     */
    public static void copyFile(String inFile, String outFile, boolean bRemoveSource) throws IOException
    {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        boolean bCanWrite = false;
        boolean bDeleted = false;

        // To preserve date/time stamp
        File fTimeIn = new File(inFile);
        File fTimeOut = new File(outFile);

        long lTimeIn = fTimeIn.lastModified();

        try
        {
            fin = new FileInputStream(inFile);
            fout = new FileOutputStream(outFile);
            copyStream(fin, fout);
        }
        catch(Exception e)
        {
        	e.printStackTrace();
        }
        finally
        {
            try
            {
                if (fin != null)
                {
                    fin.close();
                }
            }
            catch (IOException e)
            {
            	e.printStackTrace();
            }
            try
            {
                if (fout != null)
                {
                    fout.close();
                }
            }
            catch (IOException e)
            {
            	e.printStackTrace();
            }
        }

        fin.close();
        fout.close();

        // Set out time to in time
        fTimeOut.setLastModified(lTimeIn);

        if (bRemoveSource == true)
        {
            bCanWrite = fTimeIn.canWrite();
            if (bCanWrite)
            {
                bDeleted = fTimeIn.delete();
            }
        }
    }


    /**
     *  Description of the Method
     *
     * @param  in               Description of the Parameter
     * @param  out              Description of the Parameter
     * @exception  IOException  Description of the Exception
     */
    public static void copyStream(InputStream in, OutputStream out) throws IOException
    {
        // do not allow other threads to read from the
        // input or write to the output while copying is
        // taking place
        synchronized (in)
        {
            synchronized (out)
            {
                byte[] buffer = new byte[256];
                while (true)
                {
                    int bytesRead = in.read(buffer);
                    if (bytesRead == -1)
                    {
                        break;
                    }
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }


    /**
     *  Gets the lastThread attribute of the StringTools class
     *
     * @param  thread  Description of the Parameter
     * @return         The lastThread value
     */
    public static boolean isLastThread(Thread thread)
    {
        int n = thread.enumerate(new Thread[1]);
        if (n > 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
}

