package dk.kvl.tools.history;

import dk.kvl.alignmenttools.*;
import dk.kvl.sequencetools.*;

public class AddSequences implements HistoryItem
{
  private final Sequence[] sequences;
  public AddSequences(Sequence[] addedSequences)
  {
    sequences = addedSequences;
  }
  
    public void undo(Alignment alignment)
    {
      for(int i=0;i<sequences.length;i++)
      {
        alignment.removeSequence(sequences[i].getLabel());
      }
    }
    public void redo(Alignment alignment)
    {
      for(int i=0;i<sequences.length;i++)
      {
        Sequence seq = sequences[i];
        seq.setNumber(alignment.getNumberOfSequences() + 1);
        alignment.addSequence(seq);
      }
    }
    public String getLabel()
    {
      return "Sequences Added";
    }
    
    
}
