/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.tools.history;

import dk.kvl.alignmenttools.*;

public class ChangeSymbols implements HistoryItem
{
    private String[] sequences;
    private int[] index;
    private char newChar;
    private char[][] result;

    public ChangeSymbols()
    {
    }

    public void setSequences(String[] seqs)
    {
	sequences = seqs;
    }

    public void setIndex(int[] index)
    {
	this.index = index;
    }

    public void setNewChar(char nChar)
    {
	newChar = nChar;
    }

    public void setResult(char[][] res)
    {
	result = res;
    }


    public void undo(Alignment alignment)
    {
	for(int i = 0; i< sequences.length;i++)
	    {
		char[] chars = result[i];
		for(int j = 0; j< chars.length;j++)
		{
		    if(chars[j] != '!')
			{
			    alignment.changeSymbol(sequences[i], index[j], chars[j]);
			}
		}
	    }
    }

    public void redo(Alignment alignment)
    {
	alignment.changeSymbol(sequences, index, newChar);
    }

    public String getLabel()
    {
	return "Change Symbols";
    }


}
