/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen, Susie Elisabeth Kristensen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
 package dk.kvl.tools.history;

import java.util.*;
import dk.kvl.alignmenttools.*;
import dk.kvl.sequencetools.*;
import dk.kvl.controller.*;

public class DeleteSequences implements HistoryItem
{   private Sequence[] deletedSequences;

    public DeleteSequences(Sequence[] deletedSequences)
    {
	this.deletedSequences = deletedSequences;
    }

    public void undo(Alignment alignment)
    {	
	for (int i = 0; i < deletedSequences.length; i++){
	    alignment.addSequence(deletedSequences[i]);
	}
	alignment.sort();	
    }
    
    public void redo(Alignment alignment)
    {
	for (int i = 0; i < deletedSequences.length; i++){
	    alignment.removeSequence(deletedSequences[i].getLabel());
	}
	alignment.sort();
    }
    
    public String getLabel()
    {
	return "Delete sequences";
    }

}
