package dk.kvl.tools.history;

public class HistoryElement{
    private String[] names;
    private int[] index;
    private int colIndex, col1, col2, start, end;
    private char newChar, mask;
    
    
    //pairBases, tolowercase, touppercase, unpairBases
    public HistoryElement(String[] names, int[] index){
	this.names = names;
	this.index = index;
    }
    
    //rotateRight, rotateLeft
    public HistoryElement(String[] names, int start, int end){
	this.names = names;
	this.start = start;
	this.end = end;
    }
    
    //addColumn, removeColumn
    public HistoryElement(int colIndex){
	this.colIndex = colIndex;
    }
    
    //pairColumns
    public HistoryElement(int col1, int col2, char mask){
	this.col1 = col1;
	this. col2 = col2;
	this.mask = mask;
    }
    
    //changeSymbol
    public HistoryElement(String[] names, int[] index, char newChar){
	this.names = names;
	this.index = index;
	this.newChar = newChar;
    }
    
    public char getNewChar(){
	return newChar;
    }
    
    public int getColIndex(){
	return colIndex;
    }
    
    public String[] getNames(){
	return names;
    }
    
    public int[] getIndex(){
	return index;
    }
    
    public int getCol1(){
	return col1;
    }
    
    public int getCol2(){
	return col2;
    }
    
    public int getStart(){
	return start;
    }
    
    public int getEnd(){
	return end;
    }
    
    public char getMask(){
	return mask;
    }
}
