package dk.kvl.tools.history;

import dk.kvl.alignmenttools.*;

public class PairBases implements HistoryItem
{
    private String[] sequences; 
    private int[] columns;
    
    public PairBases(String[] names, int[] cols)
    {
        sequences = names;
        columns = cols;
    }
    
    public void undo(Alignment alignment)
    {
        alignment.unpair(sequences, columns);
        
    }
    public void redo(Alignment alignment)
    {
        alignment.pair(sequences, columns);
        
    }
    public String getLabel()
    {
        return "Pair bases";
    }

}
