/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.tools.history;

import java.util.*;
import dk.kvl.tools.*;
import dk.kvl.alignmenttools.*;
import dk.kvl.sequencetools.*;

public class RemoveGaps implements HistoryItem
{
    private IntArray indexs;
    private char[] pairingmask;

    public RemoveGaps(IntArray indexs, char[] mask)
    {
	this.indexs = indexs;
	pairingmask = mask;
    }

    public void undo(Alignment alignment)
    {
	for(int i = indexs.getLength()-1; i >= 0; i--)
	    {
		alignment.addColumn(indexs.get(i), '-');
		alignment.getPairingMask().changeSymbol(pairingmask[i],indexs.get(i));
	    }
    }
    public void redo(Alignment alignment)
    {
	for(int i = 0; i<indexs.getLength();i++)
	    {
		alignment.removeColumn(indexs.get(i));
	    }
    }
    public String getLabel()
    {
	return "Remove gaps";
    }

}
