/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.tools.history;

import dk.kvl.alignmenttools.*;

public abstract class Rotate implements HistoryItem
{

    private String[] sequences;
    private int start;
    private int end;
    private String[] result;


    public void setSequences(String[] seqs)
    {
	sequences = seqs;
    }

    public String[] getSequences()
    {
	return sequences;
    }

    public void setStart(int strt)
    {
	start = strt;
    }

    public int getStart()
    {
	return start;
    }

    public void setEnd(int end)
    {
	this.end = end;
    }

    public int getEnd()
    {
	return end;
    }

    public void setResult(String[] res)
    {
	result = res;
    }

    public String[] getResult()
    {
	return result;
    }

    public abstract void undo(Alignment alignment);

    public abstract void redo(Alignment alignment);

    public abstract String getLabel();

}
