package dk.kvl.tools.history;

import java.util.*;
import dk.kvl.alignmenttools.*;

public class UnpairBases implements HistoryItem
{
    private Hashtable historyData;
    private String[] sequences;
    
    public UnpairBases(String[] names, Hashtable data)
    {
        historyData = data;
        sequences = names;
    }
    
    public void undo(Alignment alignment)
    {
        String name;
        for(int i = 0; i<sequences.length;i++)
        {
            name = sequences[i];
            int[][] data = (int[][])historyData.get(name);
            for(int j = 0;j<data.length;j++)
            {
                alignment.getSequence(name).pairBases(data[j][0],data[j][1]);    
            }
        }
        //alignment.updatePairings();
    }
    public void redo(Alignment alignment)
    {
        Enumeration e = historyData.keys();
        while(e.hasMoreElements())
        {
            String key = (String)e.nextElement();
            int[][] data = (int[][])historyData.get(key);
            for(int i = 0;i<data.length;i++)
            {
                alignment.getSequence(key).unpair(data[i]);    
            }
        }
        //alignment.updatePairings();
    }
    public String getLabel()
    {
        return "Unpair bases";
    }

}
