package dk.kvl.tools.io;

import java.io.*;
import dk.kvl.tools.io.*;
import dk.kvl.tools.*;
import dk.kvl.controller.*;

public class ControllerErrorReaderThread extends Thread{
    private BufferedReader br;
    private Log log;
    private AlignmentController controller;
    
    public ControllerErrorReaderThread(BufferedReader br, Log log, AlignmentController controller){
	this.br = br;
	this.log = log;
	this.controller = controller;
    }
    
    public void run(){
	try{
	    String errorLine = br.readLine();
	    if (errorLine != null)
	    {
		log.writeLine("ERROR IN: fasta2col");
		controller.setError(true);
	    }
	    while (errorLine != null)
	    {
		if(errorLine.length() != 0)
		{
		    log.writeLine(errorLine);
		}
		errorLine = br.readLine();
	    }
	}
	catch(IOException e){
	    System.out.println("Error in ErrorReaderThread");
	}
    }
}
