package dk.kvl.tools.io;

import java.io.*;
import dk.kvl.tools.io.*;
import dk.kvl.tools.*;
import dk.kvl.controller.*;

public class IOControllerErrorReaderThread extends Thread{
    private BufferedReader br;
    private Log log;
    
    public IOControllerErrorReaderThread(BufferedReader br, Log log){
	this.br = br;
	this.log = log;
    }
    
    public void run(){
	try{
	    String errorLine = br.readLine();
	    if (errorLine != null)
	    {
		log.writeLine("ERROR IN: col2fasta");
		AlignmentIOController.setError(true);
	    }
	    while (errorLine != null)
	    {
		if(errorLine.length() != 0)
		{
		    log.writeLine(errorLine);
		}
		errorLine = br.readLine();
	    }
	}
	catch(IOException e){
	    System.out.println("Error in ErrorReaderThread");
	}
    }
}
