package src;
import java.util.ArrayList;
import java.util.Collections;


public final class MakeAlignment {
	
	private String seqA = null;
	private String seqB = null;
	private int[] temp;
	private Matches ma = null;
	private String[] results;
	
	@SuppressWarnings("unchecked")
	public MakeAlignment(ArrayList<int[]> match, Parameters p, int startA,int stopA,int startB, int stopB){
		seqA = p.getSeqA();
		seqB = p.getSeqB();
		int lengthA = seqA.length();
		int lengthB = seqB.length();
		final ArrayList<Matches> m = new ArrayList<Matches>();
		for(int a=0; a<match.size();a++){
			temp = match.get(a);
			if(temp.length == 2){
				ma = new Matches(temp[0],temp[1],'.');
				m.add(ma);
			}else{
				ma = new Matches(temp[0],temp[2],'(');
				m.add(ma);
				ma = new Matches(temp[1],temp[3],')');
				m.add(ma);
			}
		}
		
		Collections.sort(m, new MyComparator());
		String aseq="";
		String astr="";
		String bseq="";
		String bstr="";
		
		//For local alignment to add flanking regions
		if(startA>1 || startB>1){
			if(startA>startB){
				int diff = startA-startB;
				for(int i=1; i<startA;i++){
					aseq += seqA.charAt(i-1);
					astr += '~';
					if(i>diff){
						bseq += seqB.charAt(i-diff);
						bstr += '~';
					}else{
						bseq += '~';
						bstr += '~';
					}
				}
			}else{
				int diff = startB-startA;
				for(int i=1; i<startB;i++){
					bseq += seqB.charAt(i-1);
					bstr += '~';
					if(i>diff){
						aseq += seqA.charAt(i-diff-1);
						astr += '~';
					}else{
						aseq += '~';
						astr += '~';
					}
				}
			}
		}
		
		final int[] prev = new int[2];
		prev[0]=startA-1;
		prev[1]=startB-1;
		for(int b=0; b<m.size();b++){
			ma = m.get(b);
			final int la = ma.i - prev[0];
			final int lb = ma.k - prev[1];
			if(la>1){
				aseq += seqA.substring(prev[0], (prev[0]+la-1));
				for(int r=0; r<la-1;r++){
					astr += '.';
					bseq += '-';
					bstr += '-';
				}
			}
			if (lb>0) {
				for(int r=0; r<lb-1;r++){
					aseq += '-';
					astr += '-';
					bstr += '.';
				}
				bseq += seqB.substring(prev[1], (prev[1]+lb));	
				bstr += ma.c;
			}
			aseq += seqA.substring((ma.i-1),(ma.i));
			astr += ma.c;
			prev[0] = ma.i;
			prev[1] = ma.k;
		}
		//final int la = seqA.length() - prev[0];
		//final int lb = seqB.length() - prev[1];
		final int la = stopA - prev[0];
		final int lb = stopB - prev[1];
		aseq += seqA.substring(prev[0], (prev[0]+la));
		bseq += seqB.substring(prev[1], (prev[1]+lb));
		for(int r=0; r<la;r++){
			astr += '.';
		}
		for(int r=0; r<lb;r++){
			bstr += '.';
		}
		if (la<lb) {
			for(int r=0; r<lb-la;r++){
				aseq += '-';
				astr += '-';
			}
		} else {
			for(int r=0; r<la-lb;r++){
				bseq += '-';
				bstr += '-';
			}
		}
		
		//For local alignment, add flanking
		if(stopA<lengthA || stopB<lengthB){
			if(lengthA-stopA>lengthB-stopB){
				int pos = stopB;
				for(int i=stopA; i<lengthA; i++){
					aseq += seqA.charAt(i);
					astr += '~';
					if(pos<lengthB){
						bseq += seqB.charAt(pos);
						bstr += '~';
						pos++;
					}else{
						bseq += '~';
						bstr += '~';
					}
				}
			}else{
				int pos = stopA;
				for(int i=stopB; i<lengthB; i++){
					bseq += seqB.charAt(i);
					bstr += '~';
					if(pos<lengthA){
						aseq += seqA.charAt(pos);
						astr += '~';
						pos++;
					}else{
						aseq += '~';
						astr += '~';
					}
				}
			}
		}
		
		results = new String[4];
		results[0] = aseq; results[1] = astr;
		results[2] = bseq; results[3] = bstr;
		//System.out.println(aseq+'\n'+astr+'\n'+bseq+'\n'+bstr);		
	}
	
	public String[] getResults(){
		return results;
	}
}
