#include <string>
#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>
#include <algorithm>

/*
This program takes a state file (from "findstate") and a moves file as
input. Output is a new moves file, with obsolete moves removed.
*/

using namespace std;

int main(int argc, char **argv)
{
  string s, range;
  ifstream f;
  istringstream *sstr;
  int i;
  char c;
  vector< int > best_move;
  vector< int > iv;
  vector< int > rangelist; // Notice that we only need the first
                           // element of a range to identify it
  vector< double > scorelist;
  vector< int > movesrange;
  vector< string > state;

  if (argc != 3) {
    cerr << "usage: findmove <state_file> <moves_file>" << endl;
    exit(1);
  }

  // Read state file
  f.open(argv[1]);
  if (!f.good()) {
    cerr << "findmove: error in opening state file: " << argv[1] << endl;
    exit(1);
  }

  if (getline(f, s) == 0) {
    cerr << "findmove: error in reading from state file" << endl;
    exit(1);
  }

  // Read first line (best move)
  sstr = new istringstream(s);

  if (!(*sstr >> range)) {
    cerr << "findmove: error in reading from state file" << endl;
    exit(1);
  }

  delete sstr;

  // Read range
  sstr = new istringstream(range);

  for (;;) {
    if (!(*sstr >> i))
      break;
    best_move.push_back(i);
    if (!(*sstr >> c) || c != ',')
      break;
  }

  delete sstr;

  f.close();

  f.clear();

  // Go through moves file
  f.open(argv[2]);
  if (!f.good()) {
    cerr << "findmove: error in opening moves file: " << argv[2] << endl;
    exit(1);
  }

  while(getline(f, s) != 0) {
    sstr = new istringstream(s);

    if (!(*sstr >> range)) {
      cerr << "findmove: error in reading from moves file" << endl;
      exit(1);
    }

    delete sstr;

    // Read range
    sstr = new istringstream(range);

    iv.clear();

    for (;;) {
      if (!(*sstr >> i))
	break;
      iv.push_back(i);
      if (!(*sstr >> c) || c != ',')
	break;
    }

    delete sstr;

    bool no_good = false;

    for (int i = 0; i < best_move.size(); i++)
      if (find(iv.begin(), iv.end(), best_move[i]) != iv.end())
	no_good = true;  // This range is part of the best move

    if (!no_good)
      cout << s << endl;
  }

  f.close();

  return 0;
}
