#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings;
use Data::Dumper;

# Ebbe Sloth Andersen, November 2005.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<

my ( @entries, 
     $entry, 
     $count, 
     $length, 
     $i,
     $ali_file,
     $alignpos,
     $residue,
     @residue,
     @entries2,
     $label,
     $align_bp,
     @align_bp,
     $header,
	 $o,
	 $n,
	 $palindrome,
     );

( $ali_file ) = @ARGV;

@entries = &read_txt ( $ali_file );
$header = "This file was made by makeSS";
&write_col ( @entries2 );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<

sub make_pm
{
    # Ebbe Sloth Andersen, Nov 2005.

    my ( @entries ) = @_;

    my ( $entry, 
         @residue, 
         $residue, 
         $seq, 
         @rnas, 
         @labels, 
         $l, 
         $length, 
         $palindrome, 
         $n, 
         $prev, 
         $o, 
         $stem,
         $prevstem,
         $pm,
         $test,
         );



$count = pop @entries;
@residue = split(//, $count->{'seq'});
$i = 1;
foreach $residue ( @residue ) {
	$alignpos .= "$i,";
	$label .= "M,";
	push @align_bp, ".";
	$i++;
}

$length = scalar @residue;

$n = 0;
foreach $residue ( @residue ) {
	if ( $residue eq "<" ) {
		# scan forward to find opposite
		$palindrome = 0;
		for ( $i=$n; $i<$length; $i++ ) {
			if ( $residue[$i] eq "<" ) { $palindrome++; }
			if ( $residue[$i] eq ">" ) { $palindrome--; }
			if ( $palindrome == 0 ) { 
				$align_bp[$n] = $i+1;		
				$align_bp[$i] = $n+1;		
				last; 
			}
		}
    } 
	if ( $residue ne "." && $residue ne "<" && $residue ne ">" && $residue eq uc($residue) ) {
		# scan forward to find opposite
		$palindrome = 0;
		for ( $i=$n; $i<$length; $i++ ) {
			if ( $residue[$i] eq uc($residue) ) { $palindrome++; }
			if ( $residue[$i] eq lc($residue) ) { $palindrome--; }
			if ( $palindrome == 0 ) { 
				$align_bp[$n] = $i+1;		
				$align_bp[$i] = $n+1;		
				last; 
			}
		}
	}
	$n++;
}

$residue = join(",", @residue);
$align_bp = join(",", @align_bp);

push @entries2,
{
	"TYPE" => "pairingmask",
	"label" => "$label",
	"residue" => "$residue",
	"alignpos" => "$alignpos",
	"align_bp" => "$align_bp",
	"ENTRY" => $count->{'id'},
};

    return ( $header,  \@entries );
}
