#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;
use Errors;

# ADDIT3
#
# addit3 input.col resulty.col 10-20,30-40 > resultz.col
#
# Ebbe Sloth Andersen, Dec 2005.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries,
     $entries1, 
     $entries2, 
     $file1, 
     $file2,
     $f1,
     $t1,
     $f2,
     $t2,
     $line, 
     $header,
     $header2,
     $regions,
     @residue1,
     @residue,
     @align_bp,
     $entry,
     $i,
     $residue,
     @align_bp1,
     @alignpos1,
     @alignpos,
     );

( $file1, $file2, $regions ) = @ARGV;

if ( defined $regions ) {
    if ( $regions =~ /(\d+)\-(\d+)\,(\d+)\-(\d+)/ ) {
        $f1 = $1;
        $t1 = $2;
        $f2 = $3;
        $t2 = $4;
    } elsif ( $regions =~ /^(\d+)\-(\d+)$/ ) {
        $f1 = 0;
        $t1 = 0;
        $f2 = $1;
        $t2 = $2;
    }
}

( $header, $entries1 ) = &Formats::read_col ( $file1 );
( $header2, $entries2 ) = &Formats::read_col ( $file2 );

# get pairingmask entry from full alignment
$entry = $entries1->[0];

#print Dumper ( $entry );
#exit;

@residue = split ( /,/, $entry->{'residue'} );      
@align_bp = split ( /,/, $entry->{'align_bp'} );      
@alignpos = split ( /,/, $entry->{'alignpos'} );      
$i = 0;

# make pairingmask for region
foreach $residue ( @residue ) {
    if ( $i+1 >= $f1 && $i < $t1) {
        push @residue1, $residue;
        if ( $align_bp[$i] ne "." ) { 
            push @align_bp1, $align_bp[$i]+$t1-$f1-$f2+2; 
        } else {
            push @align_bp1, $align_bp[$i]; 
        }
        push @alignpos1, $alignpos[$i]-$f1+1;
    }
    if ( $i+1 >= $f2 && $i < $t2) {
        push @residue1, $residue;
        if ( $align_bp[$i] ne "." ) { 
            push @align_bp1, $align_bp[$i]-$f1+1;
        } else {
            push @align_bp1, $align_bp[$i]; 
        }
        push @alignpos1, $alignpos[$i]+$t1-$f1-$f2+2;
    }
    $i++;
}

$residue = join ( ",", @residue1 );
my $align_bp = join ( ",", @align_bp1 );
$entry = $entries2->[0];

push @{ $entries },
{
    "TYPE" => "Pairingmask",
    "label" => $entry->{'label'},
    "residue" => "$residue",
    "alignpos" => $entry->{'alignpos'},
    "align_bp" => "$align_bp",
    "ENTRY" => "SS_cons",
};
$header .= "; This file was made by addit3";
&Formats::write_col ( $header, $entries );
&Formats::write_col ( $header, $entries2 );
