package src;

public final class NewPM {
	//This makes a new matrix with the basepair probabilities for two aligned structures
	private double[][] pm;
	private double aScore = 0.0d;
	private double bScore = 0.0d;
	private boolean aiGap = false;
	private boolean biGap = false;
	private boolean ajGap = false;
	private boolean bjGap = false;
	private boolean bp = false;
	public NewPM(final String aseq, final String bseq, final Parameters p, int startA, int startB){
	    //System.out.println(aseq);
	    //System.out.println(bseq);
		final double[][] pp1 = p.getPp1();
		final double[][] pp2 = p.getPp2();
		final int n = aseq.length();
		pm = new double[n+1][n+1];
		//int ai = startA;
		//int bi = startB;
		int ai = 1;
		int bi = 1;
		for(int i=0; i<n; i++){
			aiGap=false;
			biGap=false;
			int aj=1;
			int bj=1;
			if(aseq.charAt(i) == '~'){aiGap=true;}
			if(bseq.charAt(i) == '~'){biGap=true;}
			if(aseq.charAt(i) == '-'){aiGap=true;}
			if(bseq.charAt(i) == '-'){biGap=true;}
			for(int j=0; j<n; j++){
				//System.out.println("NewPM: "+ai+" "+aj+" "+bi+" "+bj+" "+i);
				bp=false;
				ajGap=false;
				bjGap=false;
				if(aseq.charAt(j) == '~'){ajGap=true;}
				if(bseq.charAt(j) == '~'){bjGap=true;}
				if(aseq.charAt(j) == '-'){ajGap=true;}
				if(bseq.charAt(j) == '-'){bjGap=true;}							
				if(aiGap || ajGap){aScore=0.01;}
				if(biGap || bjGap){bScore=0.01;}
				//if(aj>0 && aseq.charAt(aj-1) != '~' && pp1[ai][aj] != 0.0){
				if(pp1[ai][aj] != 0.0){
					aScore = Math.max(0.01,pp1[ai][aj]);
					bp = true;
				}
				//if(bj>0 && bseq.charAt(bj-1) != '~' && pp2[bi][bj] != 0.0){
				if(pp2[bi][bj] != 0.0){
					bScore = Math.max(0.01,pp2[bi][bj]);
					bp = true;
				}
				if(bp){
					pm[i+1][j+1] = Math.sqrt(aScore * bScore);	
					//pm[i+1][j+1] = (aScore + bScore)/2;
				}
				if(ajGap){aj--;}
				if(bjGap){bj--;}
				aj++; bj++;
			}
			if(aiGap){ai--;}
			if(biGap){bi--;}
			ai++; bi++;
		}
	}
	final public double[][] getPm(){
		return pm;
	}
}
