package src;
import java.io.IOException;
import java.util.ArrayList;

public final class Wpgma {
	private double[] und;
	private int im = 0;
	private int jm = 0;
	private int k = 0;
	private double xmin = 0.0d;
	private Pairwise p = null;
	private String[] ali;
	private ArrayList<PairAlignment> pairAlignments = null;
	
	public Wpgma(final int NN, final double[][] SM, final String path) throws IOException{
		pairAlignments = new ArrayList<PairAlignment>();
		und = new double[(NN << 1)+1];
		for (int i=1; i<=NN; i++) { und[i]=1.0; }
		for (int i=NN+1; i<=(NN << 1); i++) { und[i]= -1;}
		for (k=NN+1; k<(NN << 1); k++) {
			xmin = -100000.0;
			for (int i=1; i<=(NN << 1); i++) {
				if (und[i]<0.0){continue;}
				for (int j=1; j<=(NN << 1); j++) {
					if (und[j]<0.0){continue;}
					if (i == j){continue;}
					if (xmin < SM[i][j] ) { xmin =  SM[i][j]; im = i; jm = j; }
				}
			}
			
			//System.out.println("Making pairwise:" + im + " - "+jm + " > "+k);
			p = new Pairwise(path+im+".out", path+jm+".out", path+k + ".out");
			
			//double sco = p.getScore();
			ali = new String[4];
			ali[0] = p.getSeqA();
			ali[1] = p.getStrA();
			ali[2] = p.getSeqB();
			ali[3] = p.getStrB();
			int score = p.getScore();
			final PairAlignment pa = new PairAlignment(k,im,jm,ali,score);
			pairAlignments.add(pa);
			//push @PairAlignments, [$k, $im, $jm, @ALI];
			
			for (int l=1; l<=(NN << 1); l++) {
				if (und[l]<0.0){continue;}
				if (l == k){continue;}
				if (l == im){continue;}
				if (l == jm){continue;}
				SM[k][l] = ((SM[l][im])*(und[im]/(und[im]+und[jm]))) + ((SM[l][jm])*(und[jm]/(und[im]+und[jm])));
				SM[l][k] = SM[k][l];
			}
			und[k] =und[im]+und[jm];
			und[im]= -1;
			und[jm]= -1;
			
		}
	}
	/**
	 * @return Returns the pairAlignments.
	 */
	final public ArrayList<PairAlignment> getPairAlignments() {
		return pairAlignments;
	}
}
