#include <string>
#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>
#include <algorithm>

/*
This program takes a state file and a moves file as input. Output is
the best new state file, with the new formed group as first line.
*/

using namespace std;

int main(int argc, char **argv)
{
  string s, range;
  ifstream f;
  istringstream *sstr;
  int i;
  double score;
  char c;
  int numseq;
  vector< int > iv;
  vector< int > rangelist; // Notice that we only need the first
                           // element of a range to identify it
  vector< double > scorelist;
  vector< int > movesrange;
  vector< string > state;
  string best_move;
  double best_score;
  vector< int > best_iv;

  if (argc != 3) {
    cerr << "usage: findstate <state_file> <moves_file>" << endl;
    exit(1);
  }

  // Read state
  f.open(argv[1]);
  if (!f.good()) {
    cerr << "findstate: error in opening state file: " << argv[1] << endl;
    exit(1);
  }

  while(getline(f, s) != 0) {
    // Read line
    sstr = new istringstream(s);

    if (!(*sstr >> range)) {
      cerr << "findstate: error in reading from state file" << endl;
      exit(1);
    }
    if (!(*sstr >> score)) {
      cerr << "findstate: error in reading from state file" << endl;
      exit(1);
    }

    delete sstr;

    // Read range
    sstr = new istringstream(range);

    if (!(*sstr >> i)) {
      cerr << "findstate: error in reading from state file" << endl;
      exit(1);
    }

    rangelist.push_back(i); // Range is identified by first element

    numseq = 1;

    for (;;) { // Count the sequence in the range
      if (!(*sstr >> c) || c != ',')
	break;
      if (!(*sstr >> i))
	break;
      numseq++;
    }

    delete sstr;

    scorelist.push_back(score*numseq);
    state.push_back(s);
  }

  f.close();

  f.clear();

  // Go through moves file
  f.open(argv[2]);
  if (!f.good()) {
    cerr << "findstate: error in opening moves file: " << argv[2] << endl;
    exit(1);
  }

  best_score = -1;

  while(getline(f, s) != 0) {
    sstr = new istringstream(s);

    if (!(*sstr >> range)) {
      cerr << "findstate: error in reading from moves file" << endl;
      exit(1);
    }
    if (!(*sstr >> score)) {
      cerr << "findstate: error in reading from moves file" << endl;
      exit(1);
    }

    delete sstr;

    // Read range
    sstr = new istringstream(range);

    iv.clear();

    for (;;) {
      if (!(*sstr >> i))
	break;
      iv.push_back(i);
      if (!(*sstr >> c) || c != ',')
	break;
    }

    delete sstr;

    double total = score*iv.size();
    
    for (int i = 0; i < rangelist.size(); i++)
      if (find(iv.begin(), iv.end(), rangelist[i]) == iv.end())
	total += scorelist[i];  // This range is not part of the move

    if (total > best_score) {
      best_score = total;
      best_move = s;
      best_iv = iv;
    }
  }

  f.close();

  cout << best_move << endl;

  for (int i = 0; i < rangelist.size(); i++)
    if (find(best_iv.begin(), best_iv.end(), rangelist[i]) == best_iv.end())
      cout << state[i] << endl;

  return 0;
}
