#!/usr/bin/env perl

use strict;
use warnings FATAL => qw ( all );

use Cwd;
use Data::Dumper;
use File::Basename;
use File::Path;
use File::Copy;
use Fcntl ':mode';
use IO::File;
use IO::Handle;
use Storable qw (store);

my ( $subdir, $dir, @files, @dirs );


@dirs = ( "coloring",
          "formats",
          "perl_modules",
          "plotting",
          "RNA",
          "sequence",
          );


open ( OUT, ">2bin.bash" );

foreach $dir ( @dirs ) 
{
    opendir DIR, $dir || die qq (Cannot opendir "$dir");
    @files = readdir DIR;
    shift @files;
    shift @files;
    shift @files;
    
    foreach $subdir ( @files ) {
        if ( $subdir =~ /^(\S+).pl$/ ) {
            print OUT "cp $dir/$subdir ../bin/$1\n";
        }
        if ( $subdir =~ /^(\S+).pm$/ ) {
            print OUT "cp $dir/$subdir ../bin/$subdir\n";
        }
    }
    closedir DIR;
}

close OUT;
