#! /bin/tcsh -f
#
# Use this script to run Pfold and dotplot information:
#
#   - First argument is the fasta file to analyze
#   - Second argument is the range of sequences (e.g. "1,2,4" or "4-7")
#   - Optinal third argument is an argument for a position range in the
#     Pfold run
#
# Output is one file:
#
#   - "plot.pp" Which has dotplot information
#

set PFOLD = "${SARSE_HOME}/programs/pfold/bin"
set RNADBTOOLS = "${SARSE_HOME}/programs/rnadbtools/bin"
set LOGFILE = "/dev/null"

# Find the tree
( $RNADBTOOLS/fasta2col $1 | $RNADBTOOLS/grepcol -r$2 | $PFOLD/findphyl $PFOLD/scfg.rate | $PFOLD/mltree $PFOLD/scfg.rate > tmp_tree.$$.col ) > & $LOGFILE

# Cut specific positions out
if ($3 != "") then
  # First, copy tree
  cat tmp_tree.$$.col | $RNADBTOOLS/grepcol -r1 > tmp.$$.col
  # Then cut sequence
  cat tmp_tree.$$.col | $RNADBTOOLS/grepcol -r2-10000 | $RNADBTOOLS/greppos --range=$3 >> tmp.$$.col
  mv tmp.$$.col tmp_tree.$$.col
endif

# Run Pfold
( cat tmp_tree.$$.col | $PFOLD/scfg_slow --treefile --ppfile tmp_tree.$$.col tmp.$$.pp $PFOLD/article.grm ) > & $LOGFILE

cat tmp.$$.pp

# Remove temporary files
rm tmp_tree.$$.col tmp.$$.pp
