package dk.kvl.alignmenttools.io;

import java.util.*;
import java.io.*;
import dk.kvl.alignmenttools.*;
import dk.kvl.alignmenttools.io.*;
import dk.kvl.sequencetools.*;
import javax.swing.*;
import java.awt.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    March 12, 2004
 */
public class FastaWriter extends BufferedWriter implements AlignmentWriter
{
	private Alignment alignment; 
	public FastaWriter(Alignment alignment, File outFile) throws IOException
	{
		super(new FileWriter(outFile));
		this.alignment = alignment;
		writePairingmasks();
		flush();
		writeSequences();
		flush();
		close();
	}
	
	protected void writePairingmasks()throws IOException
	{
		Enumeration e = alignment.getPairingMaskKeys();
		
		while(e.hasMoreElements())
		{
			String name = (String)e.nextElement();
			PairingMask pm = alignment.getPairingMask(name);
			write(">"+pm.getLabel(),0,pm.getLabel().length()+1);
			newLine();
			write(pm.getSequence(),0,pm.getSequence().length());
			newLine();
		}
	}
	
	protected void writeSequences()throws IOException
	{
		//Enumeration e = alignment.getSequences();
		Sequence sequence;
		String[] names = alignment.getSortedNames();
		for(int i=0;i<names.length;i++)
		{
			sequence = alignment.getSequence(names[i]);//(Sequence)e.nextElement();
			write(">"+sequence.getLabel(),0,sequence.getLabel().length()+1);
			newLine();
			write(sequence.getSequence(),0,sequence.getSequence().length());
			newLine();
		}
	}
}