/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.tools;

import dk.kvl.tools.history.*;
import dk.kvl.gui.event.*;
import java.util.*;
import dk.kvl.alignmenttools.*;

public class History extends LinkedList
{
    private int historyPosition;
    private int previousIndex = -1;
    private boolean undone;
    private transient Alignment alignment;
    private transient UpdateListener listener;

    public History(Alignment align)
    {
	alignment = align;
    }

    public History()
    {
	//this is used when a History object is loaded from file
	// must be followed by setAlignment() before use.
    }

    public boolean add(ArrayList item)
    {
	if(size()>historyPosition)
	    {
		removeTrailingHistory();
	    }
	super.add(item);
	historyPosition += 1;
	if (listener != null){
	    listener.updatePerformed(new UpdateEvent(item, 0, "add"));
	}
	return true;
    }

    public ArrayList get()
    {
	return (ArrayList)get(historyPosition-1);
    }

    public ArrayList getNext()
    {
	if(historyPosition<size())
	    {
		return (ArrayList)get(historyPosition);
	    }
	else
	    {
		return null;
	    }
    }
    
    public ArrayList redo()
    {
	ArrayList item = getNext();
	if(item != null)
	    {
		for (int i = 0; i < item.size() - 1; i++){
		    ((HistoryItem)item.get(i)).redo(alignment);
		}
		historyPosition += 1;
	    }
	return item;
    }
    
    
    public ArrayList redo(int index){
	ArrayList items = new ArrayList();
	if (historyPosition >= 0){
	    int pos = historyPosition;
	    for (int i = pos; i <= index; i++){
		items.add(redo());
	    }
	}
	return items;
    }

    public ArrayList undo()
    {
	ArrayList hi = null;
	if(historyPosition >0)
	    {
		hi = get();
		ArrayList items = get();
		for (int i = 0; i < items.size() - 1; i++){
		    ((HistoryItem)items.get(i)).undo(alignment);
		}
		historyPosition -= 1;
	    }
	return hi;
    }
    
    public ArrayList undo(int index){
	ArrayList items = new ArrayList();
	if (historyPosition > 0){
	    int pos = historyPosition - 1;
	    for (int i = index; i <= pos; i++){
		items.add(undo());
	    }
	}
	//return (HistoryItem[])items.toArray(new HistoryItem[items.size()]);
	return items;
    }

    public int getPosition()
    {
	return historyPosition;
    }
    
    public void setPosition(){
	historyPosition = size() - 1;
    }

    protected void removeTrailingHistory()
    {
	while(size()>historyPosition)
	{
	    int[] index = {indexOf(getLast())};
	    removeLast();
	    if (listener != null){
		listener.updatePerformed(new UpdateEvent(index, 1, "remove"));
	    }
	}	    
    }
    
    public void setAlignment(Alignment align)
    {
	alignment = align;
    }
    
    public void addUpdateListener(UpdateListener listener){
	this.listener = listener;
    }
    
    public int getIndex(){
	return historyPosition - 1;
    }
    
    public int getPreviousIndex(){
	return previousIndex;
    }
    
    public void setPreviousIndex(int previousIndex){
	this.previousIndex = previousIndex;
    }
    
    public void setUndone(boolean undone){
	this.undone = undone;
    }
    
    public boolean getUndone(){
	return undone;
    }
}
