package dk.kvl.tools.history;

import dk.kvl.alignmenttools.*;
import java.io.*;
import dk.kvl.tools.*;
import dk.kvl.controller.*;

public class ColFileHistoryItem implements FileHistoryItem{
    private History history;
    private String projectDir, name;
    private transient Alignment alignment;
    
    public ColFileHistoryItem(Alignment alignment, String projectDir, String name){
	try{
	    this.alignment = alignment;
	    this.projectDir = projectDir;
	    this.name = name;
	    setHistory();
	    /*history = AlignmentIOController.loadSubHistory(projectDir, name);
	    if (history == null){
		history = new History(alignment);
	    }*/
	}
	catch(Exception e){
	    System.out.println("Error reading history information: " + e);
	    e.printStackTrace();
	}
    }
    
    public ColFileHistoryItem(String projectDir, String name){
	this.projectDir = projectDir;
	this.name = name;
	/*history = AlignmentIOController.loadHistory(filePath);
	if (history == null){
	    history = new History(alignment);
	}*/
    }
    
    public void setHistory(){
	try{
	    //history = AlignmentIOController.loadSubHistory(filePath);
	    if (history == null){
		history = new History(alignment);
	    }
	}
	catch(Exception e){
	    System.out.println("Error loading history information: " + e);
	    e.printStackTrace();
	}
    }
    
    public History getHistory(){
	return history;
    }
    
    public boolean equals(Object o){
	ColFileHistoryItem item = (ColFileHistoryItem)o;
	return name.equals(item.getLabel());
    }
    
    public String getFilePath(){
	return projectDir;
    }
    
    public String getLabel(){
	return name;
    }
    
    public Alignment getAlignment(){
	return alignment;
    }
}
