package dk.kvl.tools.history;

import dk.kvl.alignmenttools.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    June 24, 2004
 */
public class PairColumns implements HistoryItem
{
    private int column1;
    private int column2;
    private char mask;


    /**
     *  Constructor for the PairColumns object
     *
     * @param  col1  Description of the Parameter
     * @param  col2  Description of the Parameter
     * @param  mask  Description of the Parameter
     */
    public PairColumns(int col1, int col2, char mask)
    {
        column1 = col1;
        column2 = col2;
        this.mask = mask;
    }


    /**
     *  Description of the Method
     *
     * @param  alignment  Description of the Parameter
     */
    public void undo(Alignment alignment)
    {
        alignment.unpairColumns(column1, column2);

    }


    /**
     *  Description of the Method
     *
     * @param  alignment  Description of the Parameter
     */
    public void redo(Alignment alignment)
    {
        alignment.pairColumns(column1, column2, mask);
    }


    /**
     *  Gets the label attribute of the PairColumns object
     *
     * @return    The label value
     */
    public String getLabel()
    {
        return "Pair columns";
    }

}

