/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.tools.history;

import java.util.*;
import dk.kvl.alignmenttools.*;
import dk.kvl.sequencetools.*;

public class RemoveColumn implements HistoryItem
{
    private int index;
    private char[] removedSymbols;

    public RemoveColumn(int index, char[] removed)
    {
	this.index = index;
	removedSymbols = removed;
    }

    public void undo(Alignment alignment)
    {
	Enumeration e = alignment.getSequences();
	int i = 0;
	while(e.hasMoreElements())
	    {
		Sequence s = (Sequence)e.nextElement();
		s.addColumn(index, removedSymbols[i]);
		i++;
	    }
	if(alignment.getPairingMask() != null)
	    {
	alignment.getPairingMask().addColumn(index, removedSymbols[removedSymbols.length-1]);
	    }
	alignment.updateLength();
    }
    public void redo(Alignment alignment)
    {
	alignment.removeColumn(index);
    }
    public String getLabel()
    {
	return "Remove column";
    }

}
