/*		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dk.kvl.tools.io;

import java.io.*;

public class Log extends BufferedWriter
{
    private StringBuffer message = new StringBuffer(); 
    
    public Log(File logFile, File workDir) throws IOException
    {
        super(new FileWriter(logFile));
        if (!logFile.exists())
            {
                if (!workDir.exists())
                {
                    workDir.mkdirs();
                }
                logFile.createNewFile();
            }
    }
    
    public void writeLine(String line) throws IOException
    {
        message.append(line+"\n");
        write(line,0,line.length());
        newLine();
    }
    
    public void write(String line) throws IOException
    {
        message.append(line);
        write(line,0,line.length());
    }
    
    public String readLog()
    {
        return message.toString();
    }
}
