package src;

import java.util.ArrayList;

public final class Parameters {

	private String seqA = null; //The sequences
	private String seqB = null;
	private short lengthA = 0; //The length of the sequences
	private short lengthB = 0;
	private double[][] sc1; //ppX contain the score^2 and sc1 contain the normalized log values of the score
	private double[][] sc2;
	private double[][] pp1;
	private double[][] pp2;
	private ArrayList[] sc1trim; //The trimmed basepairing probability matrix
	private ArrayList[] sc2trim;
	private int[][][][] S; //The resulting 4-dimensional scoring matrix
	private LongTermMemory LTM = null;
	private ShortTermMemory STM = null;
		
	/**
	 * @return Returns the lengthA.
	 */
	final public short getLengthA() {
		return lengthA;
	}
	/**
	 * @param lengthA The lengthA to set.
	 */
	public void setLengthA(short lengthA) {
		this.lengthA = lengthA;
	}
	/**
	 * @return Returns the lengthB.
	 */
	final public short getLengthB() {
		return lengthB;
	}
	/**
	 * @param lengthB The lengthB to set.
	 */
	public void setLengthB(short lengthB) {
		this.lengthB = lengthB;
	}
	/**
	 * @return Returns the seqA.
	 */
	final public String getSeqA() {
		return seqA;
	}
	/**
	 * @param seqA The seqA to set.
	 */
	public void setSeqA(String seqA) {
		this.seqA = seqA;
	}
	/**
	 * @return Returns the seqB.
	 */
	final public String getSeqB() {
		return seqB;
	}
	/**
	 * @param seqB The seqB to set.
	 */
	public void setSeqB(String seqB) {
		this.seqB = seqB;
	}
	/**
	 * @return Returns the pp1.
	 */
	final public double[][] getPp1() {
		return pp1;
	}
	/**
	 * @param pp1 The pp1 to set.
	 */
	public void setPp1(double[][] pp1) {
		this.pp1 = pp1;
	}
	/**
	 * @return Returns the pp2.
	 */
	final public double[][] getPp2() {
		return pp2;
	}
	/**
	 * @param pp2 The pp2 to set.
	 */
	public void setPp2(double[][] pp2) {
		this.pp2 = pp2;
	}
	/**
	 * @return Returns the sc1.
	 */
	final public double[][] getSc1() {
		return sc1;
	}
	/**
	 * @param sc1 The sc1 to set.
	 */
	public void setSc1(double[][] sc1) {
		this.sc1 = sc1;
	}
	/**
	 * @return Returns the sc2.
	 */
	final public double[][] getSc2() {
		return sc2;
	}
	/**
	 * @param sc2 The sc2 to set.
	 */
	public void setSc2(double[][] sc2) {
		this.sc2 = sc2;
	}
	/**
	 * @return Returns the sc1trim.
	 */
	final public ArrayList[] getSc1trim() {
		return sc1trim;
	}
	/**
	 * @param sc1trim The sc1trim to set.
	 */
	public void setSc1trim(ArrayList[] sc1trim) {
		this.sc1trim = sc1trim;
	}
	/**
	 * @return Returns the sc2trim.
	 */
	final public ArrayList[] getSc2trim() {
		return sc2trim;
	}
	/**
	 * @param sc2trim The sc2trim to set.
	 */
	public void setSc2trim(ArrayList[] sc2trim) {
		this.sc2trim = sc2trim;
	}

	/**
	 * @return Returns the lTM.
	 */
	final public LongTermMemory getLTM() {
		return LTM;
	}

	/**
	 * @param ltm The lTM to set.
	 */
	public void setLTM(LongTermMemory ltm) {
		LTM = ltm;
	}

	/**
	 * @return Returns the sTM.
	 */
	final public ShortTermMemory getSTM() {
		return STM;
	}

	/**
	 * @param stm The sTM to set.
	 */
	public void setSTM(ShortTermMemory stm) {
		STM = stm;
	}

	/**
	 * @return Returns the s.
	 */
	public final int[][][][] getS() {
		return S;
	}

	/**
	 * @param s The s to set.
	 */
	public final void setS(int[][][][] s) {
		S = s;
	}
	
}
