package src;
import java.util.ArrayList;

public final class PmCompNew{
	private int startPrune = -1500;
	private int[] pruning;
	//private short lengthA = 0;
	//private short lengthB = 0;
	private int diff = 0;
	private int pruningMax = 0;
	private short delta = 0;
	private short gap = 0;
	private static final short zero = 0;
	private String seqA = null;
	private String seqB = null;
	private Parameters p = null;
	//private double[][][][] S;
	private int seqw = 0;
	//private ArrayList[] sc1trim,sc2trim;
	private boolean nolog = false;
	//private double ss,d=0.0;
	//private double[][] substitution;
	private ArrayList<Segments> seg = null;
	private LongTermMemory LTM = null;
	private ShortTermMemory STM = null;
	private double[][] sc1;
	private double[][] sc2;
	BacktrackNew bt = null;
	private int score;
	
	public PmCompNew(final Parameters p){
		this.p = p;
		if(GlobalParameters.noprune){
			startPrune = -99999999;
		}
		int lengthA = p.getLengthA();
		int lengthB = p.getLengthB();
		pruningMax = Math.abs(lengthA-lengthB)+1;
		delta = GlobalParameters.delta;
		gap = GlobalParameters.gap;
		seqA = p.getSeqA();
		seqB = p.getSeqB();
		seqw = GlobalParameters.seqw;
		//sc1trim = p.getSc1trim();
		//sc2trim = p.getSc2trim();
		nolog = GlobalParameters.nolog;
		//substitution = p.getMatrix();
		seg = new ArrayList<Segments>();
		sc1 = p.getSc1();
		sc2 = p.getSc2();
		int max = 2*delta+1;
		pruning = new int[max];
		for(int i=0; i<max; i++){
			int factor = Math.min(pruningMax,Math.abs(delta-i));
			pruning[i] = this.startPrune + (gap*factor);
		}
	}
	
	public BacktrackNew initialize(int startA, int stopA, int startB, int stopB){
		int lengthDiff;
		final short delta = this.delta;
		//final int lengthA = this.lengthA;
		//final int lengthB = this.lengthB;
		final int lengthA = stopA;
		final int lengthB = stopB;
		//this.prune *= Math.max(5,(short)(1.1*(Math.abs(lengthA-lengthB)))+2);
		if(GlobalParameters.mode==1){
			diff = startA-startB;
		}else{
			diff=0;
		}
		final char[] seqAA = seqA.toCharArray();
		final char[] seqBA = seqB.toCharArray();
		int prune = 0; 
		STM = new ShortTermMemory(delta,diff);
		STM.setSTM(2,lengthA+1,(2*delta)+3,(2*delta)+3);
		LTM = new LongTermMemory(lengthA+1,(2*delta)+3,delta,diff);
		//LTM = new LongTermMemory(lengthA+1,lengthB+1,delta);
		//final HashMap<String,Integer> MBL = new HashMap<String,Integer>();
		for(int i=lengthA; i>=startA; i--){
			STM.set_I_Position(i);
			for(int k=lengthB; k>=startB; k--){
				if ((i-k) > delta+diff){break;}
				if ((k-i) > delta-diff){continue;}
				for(int j=i; j<=lengthA; j++){		
					for(int l=k; l<=lengthB; l++){	
						if((lengthA-j)-(lengthB-l)>delta+1){break;}
						if((lengthB-l)-(lengthA-j)>delta+1){continue;}
						lengthDiff = (j-i)-(l-k);
						if (-lengthDiff > delta){break;}
						//if (((j-i)-(l-k))> delta){continue;}
						if (lengthDiff > delta){continue;}
						prune = pruning[lengthDiff+delta]; 
						//lengthDiff++;
						//if ((i-k) > delta){break;}
						//if ((k-i) > delta){continue;}
						if(i==j && k==l){
							STM.put(i,j,k,l,0,'V',zero,zero,null);
						}
						int ik = 0;
						int jl = 0;
						int J = 0;
						int L = 0;
						
						final ShortCell scell = STM.getCell(i,j,k,l);
						if(scell==null){
							//counter++;
							continue;
							}
						final int currPos = STM.getScore(i,j,k,l);
						final char state = STM.getState(i,j,k,l);
						char overState = '\0';
						short[] mblPointer = STM.getPointer(i,j,k,l);
						if(state == 'V'){overState='V';}else{overState='H';}
						/*if(i==1 && j==66){	
							System.out.println(i+" "+j+" "+k+" "+l+" ::: "+delta+" "+diff+" "+startA+" "+lengthA+" "+startB+" "+lengthB);
							if(mblPointer!=null){
							System.out.println(mblPointer[0]+" "+mblPointer[1]+" "+mblPointer[2]+" "+mblPointer[3]+" "+mblPointer[4]+" "+mblPointer[5]);
							}else{System.out.println("NULL");}
						}*/
						if(state == 'M'){
							J = scell.getMbJ();
							L = scell.getMbL();
							LTM.put(i,J,k,L,currPos,mblPointer,state);
							mblPointer = new short[6];
							mblPointer[0] = (short)i;
							mblPointer[1] = (short)j;
							mblPointer[2] = (short)J;
							mblPointer[3] = (short)k;
							mblPointer[4] = (short)l;
							mblPointer[5] = (short)L;
							if(i==startA && j==lengthA && k==startB && l==lengthB){
								STM.put(i,j,k,l,currPos,'V',zero,zero,mblPointer);
							}
							//System.out.println("POINTER: "+mblPointer[0]+" "+mblPointer[1]+" "+mblPointer[2]+" "+mblPointer[3]+" "+mblPointer[4]+" "+mblPointer[5]);
							//mblPointer = ""+i+","+j+","+J+","+k+","+l+","+L;
							/*if(currPos>0){
								System.out.println("NEW MBL: "+mblPointer+ "   "+currPos);
							}*/
							
						}
						
						if(state == 'P'){
							LTM.put(i,j,k,l,currPos,mblPointer,state);
						}	
						
						if(i>startA && k>startB){
							ik = (seqAA[i-2] == seqBA[k-2] ? seqw : 0) + currPos;
							//ik = seq_score(seqAA[i-2],seqBA[k-2]) + currPos;
							if(ik>STM.getScore(i-1,j,k-1,l) && ik>prune){
								STM.put(i-1,j,k-1,l,ik,'V',zero,zero,mblPointer);
							}
						}
						
						if(i>startA){
							ik=currPos+gap;
							if(ik>STM.getScore(i-1,j,k,l) && ik>prune){STM.put(i-1,j,k,l,ik,'V',zero,zero,mblPointer);}
						}
						if(k>startB){
							ik = currPos+gap;
							if(ik>STM.getScore(i,j,k-1,l)&& ik>prune){STM.put(i,j,k-1,l,ik,'V',zero,zero,mblPointer);}
						}
						
						if(j<lengthA && l<lengthB){
							jl = (seqAA[j] == seqBA[l] ? seqw : 0) + currPos;
							//jl = seq_score(seqAA[j],seqBA[l]) + currPos;
							if(jl>STM.getScore(i,j+1,k,l+1) && jl>prune){
								if(overState == 'H'){
									STM.put(i,j+1,k,l+1,jl,'W',zero,zero,mblPointer);
								}else{
									STM.put(i,j+1,k,l+1,jl,'V',zero,zero,mblPointer);
								}
							}						
						}
						if(j<lengthA){
							jl = currPos+gap;
							if(jl>STM.getScore(i,j+1,k,l) && jl>prune){
								if(overState == 'H'){
									STM.put(i,j+1,k,l,jl,'W',zero,zero,mblPointer);
								}else{
									STM.put(i,j+1,k,l,jl,'V',zero,zero,mblPointer);
								}
							}
						}
						if(l<lengthB){
							jl=currPos+gap;
							if(jl>STM.getScore(i,j,k,l+1) && jl>prune){
								if(overState == 'H'){
									STM.put(i,j,k,l+1,jl,'W',zero,zero,mblPointer);
								}else{
									STM.put(i,j,k,l+1,jl,'V',zero,zero,mblPointer);
								}
							}
						}						
						
						if(overState == 'H'){
							//if(j<lengthA && l<lengthB && Math.abs(j-l) < delta){
							if(j<lengthA && l<lengthB && (j-l) <= delta+diff && (l-j) <= delta-diff){
							//if(j<lengthA && l<lengthB){
								final ArrayList<LongCell> cells = LTM.getList(j+1,l+1);
								if(cells != null){
									for(int x=0; x<cells.size(); x++){
										J = cells.get(x).getJ();
										L = cells.get(x).getL();
										final int LTMScore = cells.get(x).getScore();
										if(Math.abs((L-k)-(J-i))<delta+1 && cells.get(x).getState()=='P'){
											if(LTMScore+currPos > STM.getScore(i,J,k,L) && (LTMScore+currPos)>prune){
												STM.put(i,J,k,L,(LTMScore+currPos),'M',(short)j,(short)l,mblPointer);
											}
										}
									}
								}
							}
						}
						if(j<lengthA && l<lengthB && i>startA && k>startB && j-i>1 && l-k>1){
							//if ((((l+1)-(k-1))-((j+1)-(i-1)))>delta){break;}
							//if (((j-h)-(l-q))>delta){break;}
							if(sc1[i-1][j+1] == 0.0){
								continue;
							}
							//for(int q=k+4; q<=l; q++){
							if(sc2[k-1][l+1] == 0.0){
								continue;
							}		
							Double sm = (nolog ? (2*(sc1[i-1][j+1]*sc2[k-1][l+1])) : sc1[i-1][j+1]+sc2[k-1][l+1]);
							sm *= 100;
							int sc = sm.intValue();
							sc += currPos; //!!! + (k-k)*gap;
							
							if(sc>STM.getScore(i-1,j+1,k-1,l+1) && sc>prune){
								//System.out.println("BP: "+(i-1)+" "+(j+1)+" "+(k-1)+" "+(l+1)+"  "+sm);		
								STM.put(i-1,j+1,k-1,l+1,sc,'P',zero,zero,mblPointer);
							}
						}
					}
				}
			}
			if(i!=startA){
				STM.transfer();
			}
		}
		/*int LTMSize = 0;
		for(int x=0; x<lengthA;x++){
			for(int y=0; y<(2*delta)+3;y++){
				ArrayList c = LTM.getListReal(x,y);
				if(c != null){
					LTMSize += c.size();
				}	
			}
		}
		System.err.println("LTM Size: "+ LTMSize + " LengthA: "+lengthA+"  Delta: "+delta);*/
		//System.out.println("Pruned cells = "+counter);
		p.setSTM(STM);
		STM.set_I_Position(startA);
		final int score = STM.getScore(startA,lengthA,startB,lengthB);
		this.score = score;
		final short[] pointer = STM.getPointer(startA,lengthA,startB,lengthB);
		//System.out.println("First Score: "+ score);
		if(pointer!=null){
			//System.out.println("First Pointer: "+ pointer[0]+" "+pointer[1]+" "+pointer[2]+" "+pointer[3]+" "+pointer[4]+" "+pointer[5]);
		}else{
			//System.out.println("First Pointer: NULL");
		}
		bt = new BacktrackNew(p);
		if(pointer!=null){
			int i = pointer[0];
			int j = pointer[1];
			int k = pointer[3];
			int l = pointer[4];
			end(startA,i,j,lengthA,startB,k,l,lengthB);
			bt.track(startA,lengthA,startB,lengthB,i,j,k,l);
			//end(1,i-1,j+1,lengthA,1,k-1,l+1,lengthB);
			//bt.track(1,lengthA,1,lengthB,i-1,j+1,k-1,l+1);
			getSegments(pointer,score);
			LTM = null;
			for(int z=0; z < seg.size(); z++){
				final Segments s = seg.get(z);
				final int i_begin = s.getI_begin(); 
				final int i_end = s.getI_end();
				final int j_begin = s.getJ_begin(); 
				final int j_end = s.getJ_end();
				final int k_begin = s.getK_begin(); 
				final int k_end = s.getK_end();
				final int l_begin = s.getL_begin(); 
				final int l_end = s.getL_end();
				//System.out.println("FINAL: "+i_begin+" "+i_end+" "+j_begin+" "+j_end+" "+k_begin+" "+k_end+" "+l_begin+" "+l_end+" "+s.isEnd());
				if(s.isEnd()){
					end(i_begin,i_end,j_begin,j_end,k_begin,k_end,l_begin,l_end);
				}else{
					noMBL(i_begin,i_end,j_begin,j_end,k_begin,k_end,l_begin,l_end);
				}
				bt.track(i_begin,j_end,k_begin,l_end,i_end,j_begin,k_end,l_begin);
			}
		}else{
			//backtrack the whole thing
			//System.out.println("Bactracking everything: "+startA+" to "+lengthA + " and "+startB+" to "+lengthB);
			noMBL(startA,lengthA,startA,lengthA,startB,lengthB,startB,lengthB);
			//System.out.println("Done filling out the DPM for everything");
			bt.track(startA,lengthA,startB,lengthB,lengthA,startA,lengthB,startB);
			//System.out.println("Done backtracking everything");
		}
		return bt;
		//return STM.getScore(1,lengthA,1,lengthB);
	}
	/*public int seq_score(final char a, final char b){
		if(a == b){return seqw;}else{return 0;}
		//int x = p.charToInt(a);
		//int y = p.charToInt(b);
		//return substitution[x][y];
	}*/
	
	public void getSegments(final short[] pointer,final double score){
		final short i = pointer[0];
		final short j = pointer[1];
		final short J = pointer[2];
		final short k = pointer[3];
		final short l = pointer[4];
		final short L = pointer[5];
		//System.out.println("Pointer: "+score + "-----"+pointer);
		Segments s = null;
		//seg.add(s);
		ArrayList<LongCell> cells = LTM.getList(i,k);
		if(cells != null){
			for(int x=0; x<cells.size(); x++){
				final int JJ = cells.get(x).getJ();
				final int LL = cells.get(x).getL();
				//System.out.println("Left CELLS: "+i+" "+k+" "+JJ+" "+LL);
				if(JJ == J && LL == L){
					final int LTMScore = cells.get(x).getScore();
					final short[] leftPointer =cells.get(x).getMblPointer();
					//System.out.println("LEFT Segment: Score: "+LTMScore + "----"+i+" "+J+" "+k+" "+L+" Pointer:"+leftPointer);
					if(leftPointer==null){
						//System.out.println("LEFT Segment Null: Score: "+LTMScore + "----"+i+" "+J+" "+k+" "+L);
						s = new Segments(i,J,i,J,k,L,k,L,false);
						seg.add(s);
						break;
					}else{
						final short li = leftPointer[0];
						final short lj = leftPointer[1];
						final short lk = leftPointer[3];
						final short ll = leftPointer[4];
						if(! (i==li&&lj==J&&k==lk&&ll==L)){
							s = new Segments(i,li,lj,J,k,lk,ll,L,true);
							seg.add(s);
							//end(i,li,lj,J,k,lk,ll,L);		
							//bt.track(i,J,k,L,li,lj,lk,ll);
						}
						getSegments(leftPointer, LTMScore);
						break;
					}
				}
			}
		}
		cells = LTM.getList(J+1,L+1);
		if(cells != null){
			for(int x=0; x<cells.size(); x++){
				final int JJ = cells.get(x).getJ();
				final int LL = cells.get(x).getL();
				//System.out.println("Right CELLS: "+(J+1)+" "+(L+1)+" "+JJ+" "+LL);
				if(JJ == j && LL == l){
					final int LTMScore = cells.get(x).getScore();
					final short[] rightPointer =cells.get(x).getMblPointer();
					//System.out.println("Right Segment: Score: "+LTMScore + "----"+(J+1)+" "+j+" "+(L+1)+" "+l+" Pointer:"+rightPointer);
					if(rightPointer==null){
						//System.out.println("RIGHT Segment Null: Score: "+LTMScore + "----"+(J+1)+" "+JJ+" "+(L+1)+" "+LL);
						s = new Segments(J+1,JJ,J+1,JJ,L+1,LL,L+1,LL,false);
						seg.add(s);
						break;
					}else{
						final short ri = rightPointer[0];
						final short rj = rightPointer[1];
						final short rk = rightPointer[3];
						final short rl = rightPointer[4];
						if(! (J+1==ri&&rj==j&&L+1==rk&&rl==l)){
							s = new Segments(J+1,ri,rj,j,L+1,rk,rl,l,true);
							seg.add(s);
							//end(J+1,ri,rj,j,L+1,rk,rl,l);		
							//bt.track(J+1,j,L+1,l,ri,rj,rk,rl);
						}					
						getSegments(rightPointer, LTMScore);
						break;
					}
				}
			}
		}
	}
	
	public void noMBL(final int i_begin, final int i_end, final int j_begin, final int j_end, final int k_begin, final int k_end, final int l_begin, final int l_end){
		STM.setSTM(i_end-i_begin+1,j_end-j_begin+1,(2*delta)+3,(2*delta)+3);
		STM.set_I_Position(i_begin);
		STM.set_J_Position(j_begin);
		final char[] seqAA = seqA.toCharArray();
		final char[] seqBA = seqB.toCharArray();
		int prune;
		int lengthDiff;
		for(int i=i_end; i>i_begin-1; i--){
			for(int k=k_end; k>k_begin-1; k--){
				if ((i-k) > delta+diff){break;}
				if ((k-i) > delta-diff){continue;}
				for(int j=i; j<=j_end; j++){
					for(int l=k; l<=l_end; l++){	
						if((j_end-j)-(l_end-l)>delta+1){break;}
						if((l_end-l)-(j_end-j)>delta+1){continue;}
						if (((l-k)-(j-i)) > delta){break;}
						if (((j-i)-(l-k))> delta){continue;}
						//if ((i-k) > delta){break;}
						//if ((k-i) > delta){continue;}	
						lengthDiff = (j-i)-(l-k);
						prune = pruning[lengthDiff+delta]; 
						int ik = 0;
						int jl = 0;
						if(i==j && k==l){
							STM.putAll(i,j,k,l,0);
						}
						if(STM.getAllCell(i,j,k,l)==null){continue;}
						final int currPos = STM.getAll(i,j,k,l);
						//System.out.println("GetAll: "+i+" "+j+" "+k+" "+l+"  "+currPos);			
						if(i>i_begin && k>k_begin){
							ik = (seqAA[i-2] == seqBA[k-2] ? seqw : 0) + currPos;
							//ik = seq_score(seqAA[i-2],seqBA[k-2]) +currPos;
							if(ik>STM.getAll(i-1,j,k-1,l) && ik>prune){STM.putAll(i-1,j,k-1,l,ik);}
						}	
						if(i>i_begin){
							ik=currPos+gap;
							if(ik>STM.getAll(i-1,j,k,l) && ik>prune){STM.putAll(i-1,j,k,l,ik);}
						}
						if(k>k_begin){
							ik=currPos+gap;
							if(ik>STM.getAll(i,j,k-1,l) && ik>prune){STM.putAll(i,j,k-1,l,ik);}
						}
						
						if(j<j_end && l<l_end){
							jl = (seqAA[j] == seqBA[l] ? seqw : 0) +currPos;
							//jl = seq_score(seqAA[j],seqBA[l]) + currPos;	
							if(jl>STM.getAll(i,j+1,k,l+1) && jl>prune){STM.putAll(i,j+1,k,l+1,jl);}						
						}
						if(j<j_end){
							jl=currPos+gap;
							if(jl>STM.getAll(i,j+1,k,l) && jl>prune){STM.putAll(i,j+1,k,l,jl);}
						}
						if(l<l_end){
							jl=currPos+gap;
							if(jl>STM.getAll(i,j,k,l+1) && jl>prune){STM.putAll(i,j,k,l+1,jl);}
						}						
						
						if(j<j_end && l<l_end && i>i_begin && k>k_begin && j-i>1 && l-k>1){
							//if ((((l+1)-(k-1))-((j+1)-(i-1)))>delta){break;}
							if(sc1[i-1][j+1] == 0.0){
								continue;
							}
							//for(int q=k+4; q<=l; q++){
							if(sc2[k-1][l+1] == 0.0){
								continue;
							}		
							Double sm = nolog ? (2*(sc1[i-1][j+1]*sc2[k-1][l+1])) : sc1[i-1][j+1]+sc2[k-1][l+1];
							sm *= 100;
							int sc = sm.intValue();
							sc += currPos; //!!! + (k-k)*gap;
							if(sc>STM.getAll(i-1,j+1,k-1,l+1) && sc>prune){
								//System.out.println("BP: "+(i-1)+" "+(j+1)+" "+(k-1)+" "+(l+1)+"  "+sm);		
								STM.putAll(i-1,j+1,k-1,l+1,sc);
							}
						}
					}
				}
			}
		}
		p.setSTM(STM);
		//double score = STM.getAll(i_begin,i_end,k_begin,k_end);
		//System.err.println("Score: "+ score);
	}
	
	public void end(final int i_begin, final int i_end, final int j_begin, final int j_end, final int k_begin, final int k_end, final int l_begin, final int l_end){
		STM.setSTM(i_end-i_begin+1,j_end-j_begin+1,(2*delta)+3,(2*delta)+3);
		STM.set_I_Position(i_begin);
		STM.set_J_Position(j_begin);
		STM.putAll(i_end,j_begin,k_end,l_begin,0);
		final char[] seqAA = seqA.toCharArray();
		final char[] seqBA = seqB.toCharArray();
		int lengthDiff;
		int prune;
		for(int i=i_end; i>i_begin-1; i--){
			for(int k=k_end; k>k_begin-1; k--){
				if ((i-k) > delta+diff){break;}
				if ((k-i) > delta-diff){continue;}
				for(int j=j_begin; j<=j_end; j++){
					for(int l=l_begin; l<=l_end; l++){	
						if((j_end-j)-(l_end-l)>delta+1){break;}
						if((l_end-l)-(j_end-j)>delta+1){continue;}
						lengthDiff = (j-i)-(l-k);
						//if (-lengthDiff > delta){break;}
						//if (lengthDiff > delta){continue;}
						if (((l-k)-(j-i)) > delta){break;}
						if (((j-i)-(l-k))> delta){continue;}
						//lengthDiff++;
						//if ((i-k) > delta){break;}
						//if ((k-i) > delta){continue;}
						prune = pruning[lengthDiff+delta]; 
						int ik = 0;
						int jl = 0;
						/*if(i==j && k==l){
							STM.putAll(i,j,k,l,0);
						}*/
						if(STM.getAllCell(i,j,k,l)==null){continue;}
						final int currPos = STM.getAll(i,j,k,l);
						//System.out.println("GetAll: "+i+" "+j+" "+k+" "+l+"  "+currPos);			
						if(i>i_begin && k>k_begin){
							ik = (seqAA[i-2] == seqBA[k-2] ? seqw : 0) +currPos;
							//ik = seq_score(seqAA[i-2],seqBA[k-2]) +currPos;
							if(ik>STM.getAll(i-1,j,k-1,l) && ik>prune){STM.putAll(i-1,j,k-1,l,ik);}
						}	
						if(i>i_begin){
							ik=currPos+gap;
							if(ik>STM.getAll(i-1,j,k,l) && ik>prune){STM.putAll(i-1,j,k,l,ik);}
						}
						if(k>k_begin){
							ik=currPos+gap;
							if(ik>STM.getAll(i,j,k-1,l) && ik>prune){STM.putAll(i,j,k-1,l,ik);}
						}
						
						if(j<j_end && l<l_end){
							jl = (seqAA[j] == seqBA[l] ? seqw : 0) + currPos;
							//jl = seq_score(seqAA[j],seqBA[l]) + currPos;
							if(jl>STM.getAll(i,j+1,k,l+1) && jl>prune){STM.putAll(i,j+1,k,l+1,jl);}						
						}
						if(j<j_end){
							jl=currPos+gap;
							if(jl>STM.getAll(i,j+1,k,l) && jl>prune){STM.putAll(i,j+1,k,l,jl);}
						}
						if(l<l_end){
							jl=currPos+gap;
							if(jl>STM.getAll(i,j,k,l+1) && jl>prune){STM.putAll(i,j,k,l+1,jl);}
						}						
						
						if(j<j_end && l<l_end && i>i_begin && k>k_begin && j-i>1 && l-k>1){
							//if ((((l+1)-(k-1))-((j+1)-(i-1)))>delta){break;}
							if(sc1[i-1][j+1] == 0.0){
								continue;
							}
							//for(int q=k+4; q<=l; q++){
							if(sc2[k-1][l+1] == 0.0){
								continue;
							}		
							Double sm = nolog ? (2*(sc1[i-1][j+1]*sc2[k-1][l+1])) : sc1[i-1][j+1]+sc2[k-1][l+1];
							sm *= 100;
							int sc = sm.intValue();
							sc += currPos; //!!! + (k-k)*gap;
							if(sc>STM.getAll(i-1,j+1,k-1,l+1) && sc>prune){
								//System.out.println("BP: "+(i-1)+" "+(j+1)+" "+(k-1)+" "+(l+1)+"  "+sm);		
								STM.putAll(i-1,j+1,k-1,l+1,sc);
							}
						}
					}
				}
			}
		}
		p.setSTM(STM);
		//double score = STM.getAll(i_begin,j_end,k_begin,l_end);
		//System.err.println("Score: "+ score);
	}
	public int getScore(){
		return score;
	}
}
