package src;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public final class ReadBPMatrix {
	private double score = 0.0d;
	private double[][] pp1;
	private double[][] pp2;
	private double[][] sc1;
	private double[][] sc2;
	private String seqA = null;
	private String seqB = null;
	private short lengthA = 0;
	private short lengthB = 0;
	private Parameters para = null;
	private boolean nolog = false;
	
	public ReadBPMatrix(String fileA, String fileB) throws IOException{
		String line = null;
		String line2 = null;
		int i =0;
		int j =0;
		int k =0;
		int l =0;
		//File A
		final InputStream input = new FileInputStream(fileA);
		final BufferedReader fil = new BufferedReader(new InputStreamReader(input));
		line = fil.readLine();
		Pattern p = Pattern.compile("^Sequence:(.*)$");
		Matcher m = p.matcher(line);
		if(m.find()){
			seqA = m.group(1);
		}
		lengthA = (short)seqA.length();
		
		//File B
		final InputStream input2 = new FileInputStream(fileB);
		final BufferedReader fil2 = new BufferedReader(new InputStreamReader(input2));
		line2 = fil2.readLine();
		Pattern p2 = Pattern.compile("^Sequence:(.*)$");
		Matcher m2 = p.matcher(line2);
		
		if(m2.find()){
			seqB = m2.group(1);
		}
		lengthB = (short)seqB.length();
	
		pp1 = new double[lengthA+2][lengthA+2];
		pp2 = new double[lengthB+2][lengthB+2];
		sc1 = new double[lengthA+2][lengthA+2];
		sc2 = new double[lengthB+2][lengthB+2];
		
		p = Pattern.compile("(\\d+)\\s+(\\d+)\\s+(\\d+\\.\\d+).*");
		while((line = fil.readLine()) != null){
			m = p.matcher(line);
			if(m.find()){
				i = Integer.parseInt(m.group(1));
				j = Integer.parseInt(m.group(2));
				score = Double.parseDouble(m.group(3));
			}
			if(score > 0.01){
				pp1[i][j] = (score*score);
				//pp1[i][j] = (score);
				if(!nolog){
					score = Math.log(score*lengthA*2.0)/Math.log(lengthA*2);
				}else{
					score *= score;
				}
				if(score > 0.0){sc1[i][j] = score;}
			}
		}
		fil.close();
		
		p2 = Pattern.compile("(\\d+)\\s+(\\d+)\\s+(\\d+\\.\\d+).*");
		while((line2 = fil2.readLine()) != null){
			m2 = p2.matcher(line2);
			if(m2.find()){
				k = Integer.parseInt(m2.group(1));
				l = Integer.parseInt(m2.group(2));
				score = Double.parseDouble(m2.group(3));
			}
			if(score > 0.01){
				pp2[k][l] = (score*score);
				//pp2[k][l] = (score);
				if(!nolog){
					score = Math.log(score*lengthB*2.0)/Math.log(lengthB*2);
				}else{
					score *= score;
				}
				if(score > 0.0){sc2[k][l] = score;}
			}
		}
		fil2.close();
				
		para = new Parameters();
		para.setLengthA(lengthA);
		para.setLengthB(lengthB);
		para.setSeqA(seqA);
		para.setSeqB(seqB);
		para.setSc1(sc1);
		para.setSc2(sc2);	
		para.setPp1(pp1);
		para.setPp2(pp2);
		//Increase the delta size if it's shorter than the differnce between the sequence lengths
		if (GlobalParameters.mode != 1){
			short delta = (short)Math.max(10,(short)(1.1*(Math.abs(lengthA-lengthB)))+1);
			GlobalParameters.delta = delta;
			if(delta > 10){
			    //System.out.println("Changing delta to "+ GlobalParameters.delta);
			}
		}
	}
	final public Parameters getParameters(){
		return para;
	}
}
