package Errors;

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;

# check_col

sub check_col
{
    my ( $entries,
         $args,
        ) = @_;
    
    my ( $prog_name, $key, $value, @list, @errors );
    
    $prog_name = ( split "/", $0 )[-1];
    
    foreach $key ( %{ $args } )
    {
        foreach $value ( @{ $args->{ $key } } )
        {
            @list = grep { exists $_->{ $key } and $_->{ $key } eq $value } @{ $entries };
            
            if ( not @list ) {
                push @errors, qq ($prog_name: $value info is required in input file\n);
            }
        }
    }
    
    if ( @errors )
    {
        print STDERR @errors and exit;
    }
    
    return;
}

1;
