#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;
use Errors;

# REASSEMBLE_FA
#
# reassemble_fa left.col $right.col input.col -r10-30,40-50 > result.col
#
# Ebbe Sloth Andersen, 2007.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries,
     $entries1, 
     $entries2, 
     $entries3, 
     $file1, 
     $file2,
     $file3,
     $header,
     $regions,
     );

( $file1, $file2, $file3, $regions ) = @ARGV;
$entries1 = &Formats::read_col ( $file1 );
$entries2 = &Formats::read_col ( $file2 );
$entries3 = &Formats::read_col ( $file3 );
#&Errors::check_col ( $entries1, { "TYPE" => ["RNA","pairingmask"],
#						         "COL"  => ["certainty","align_bp"] } );
#&Errors::check_col ( $entries2, { "TYPE" => ["RNA","pairingmask"],
#						         "COL"  => ["certainty","align_bp"] } );
$header .= "This file was made by reassemble_fa";
if ( defined $regions ) {
    $entries = &reassemble ( $entries1, $entries2, $entries3, $regions );
} else {
    $entries = $entries1;
}

#print Dumper ( $entries );
#exit;

&Formats::write_col ( $header, $entries );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<

sub reassemble
{
    my ( $entries1, $entries2, $entries3, $regions ) = @_;
    
    my ( $entries,
        $entry,
         @residue,
         @residue1,
         @residue2,
         @pairingmask,
         $i,
         $s,
         @result,
         @prime5,
         @middle,
         @prime3,
         @ligate,
         $residue1,
         $residuex,
         $residuey,
         $prime5,
         @x,
         @catch1,
         @catch2,
         @left,
         @right,
         $ENTRY,
         $TYPE,
         $end,
         $p5,
         $p3,
         $middle,
         $pos,
         $length,
         $residue,
         $pairingmask,
         @certainty,
         $certainty,
         @align_bp,
         $align_bp,
         $alignpos,
         $label,
         $label2,
         $seqpos,
         $pm,
         $prev,
         $count,
		 $f1,
		 $t1,
		 $f2,
		 $t2,
         );

if ( defined $regions ) {
    if ( $regions =~ /^\-r(\d+)\-(\d+)\,(\d+)\-(\d+)/ ) {
        $f1 = $1;
        $t1 = $2;
        $f2 = $3;
        $t2 = $4;
    } elsif ( $regions =~ /^\-r(\d+)\-(\d+)$/ ) {
        $f1 = 0;
        $t1 = 0;
        $f2 = $1;
        $t2 = $2;
    }
}

    foreach $entry ( @{ $entries3 } ) {
        
        # input file
        $TYPE = $entry->{'TYPE'};
        $ENTRY = $entry->{'ENTRY'};

        # input file data
        @residue = ( );
        @residue = split ( /,/, $entry->{'residue'} );      
            
        # Find The same entry in result files
        @catch1 = grep { $_->{'ENTRY'} eq "$ENTRY" } @{ $entries1 }; 
        @catch2 = grep { $_->{'ENTRY'} eq "$ENTRY" } @{ $entries2 };
        @left = split ( /,/, $catch1[0]->{'residue'} );  
        @right = split ( /,/, $catch2[0]->{'residue'} );  

        # retrieve missing parts from input file
        @prime5 = ( );
        @middle = ( );
        @prime3 = ( );

        $end = scalar @residue;
        @x = @residue;
        @prime5 = splice @x, 0, $f1-1;
        @x = @residue;
        @middle = splice @x, $t1, $f2-$t1-1;
        @x = @residue;
        @prime3 = splice @x, $t2, $end-$t2;
            
        if ( $f1 == 0 && $t1 == 0 ) { @prime5 = ( ) };
            
        # splice them together (one-after-the-other)
        $pm = scalar @prime5;
        splice @prime5, $pm, 0, @left;
        $pm = scalar @prime5;
        splice @prime5, $pm, 0, @middle;
        $pm = scalar @prime5;
        splice @prime5, $pm, 0, @right;
        $pm = scalar @prime5;
        splice @prime5, $pm, 0, @prime3;

        # regenerate standard columns            
        $i = 1;
        $s = 1;
        $seqpos = "";
        $alignpos = "";
        $label = "";
        foreach $residue ( @prime5 ) {
            if ( $residue eq "-" ) { 
                $seqpos .= ".,"; 
                $label .= "G,"; 
            } else {
                $seqpos .= "$s,";
                $label .= "N,"; 
                $s++;
            } 
            $alignpos .= "$i,";
            $label2 .= "M,";
            $i++;
        }            

        # join them
        $residue = "";
        $residue = join ( ',', @prime5 );
                
        # print the extended sequence into result file
        push @{ $entries},
        { 
            "TYPE" => $entry->{'TYPE'},
            "label" => $label,
            "residue" => $residue,
            "alignpos" => $alignpos,
            "seqpos" => $seqpos,
            "ENTRY" => $entry->{'ENTRY'},
        }
    }
	    
    return $entries;
}
