package src;

import java.util.ArrayList;


public final class BacktrackFast implements Backtrack {
	
	private Double sm;
	private int seqw;
	private int[][][][] S;
	private double[][] sc1,sc2;
	private int gap,delta;
	private String seqA, seqB;
	private ArrayList<int[]> match;
	private boolean nolog;
	private int i,j,k,l,offset;
	private double score1, score2;
	private boolean found;
	public BacktrackFast(Parameters p){
		//substitution = p.getMatrix();
		seqw = GlobalParameters.seqw;
		S = p.getS();
		sc1 = p.getSc1();
		sc2 = p.getSc2();
		gap = GlobalParameters.gap;
		delta = GlobalParameters.delta;
		seqA = p.getSeqA();
		seqB = p.getSeqB();
		nolog = GlobalParameters.nolog;
		i = 1; k = 2*delta+1;
		j = p.getLengthA()-1;
		offset = p.getLengthB()-p.getLengthA();
		l = (delta+1)+offset;
		match = new ArrayList<int[]>();
		System.err.println("Bactracking from: i="+i+" j:"+(i+j)+" k:"+(i + (k-(2*delta+1)))+" l:"+(j + (i + (k-(2*delta+1)) + (l-(delta+1)))));
		track(i,k,j,l);
	}
	public void track(int i,int k,int j,int l){
		 found = false;
		int realJ = i+j;
		int realK = i + (k-(2*delta+1));
		int realL = j + realK + (l-(delta+1));
		while((i <= realJ) && (realK <= realL)){
		    realJ = i+j;
			realK = i + (k-(2*delta+1));
			realL = j + realK + (l-(delta+1));
			//System.out.println("offset:"+offset+ " "+i + " "+realJ+" "+" "+realK+" "+" "+realL +" j:"+j+" k:"+k+" l:"+l+ " - "+S[i][k][j][l]);
			//Check if the i-j, k-l pairs are equal and create an end score with gaps if they are
			if(i==realJ || l>(2*delta)+1){
				score1 = Math.abs(realJ-i-1+realK-realL)*gap;
			}else{
				score1 = (S[i+1][k-1][j-1][l+1] + gap);
			}
			
			if(realK==realL || i==realJ){
				score2 = Math.abs(realJ-i+realK-realL)*gap;
			} else {
				score2 = S[i+1][k][j-1][l];	
			}
			//System.out.println(i+ " -- "+realK + " SeqA:"+seqA.charAt(i-1)+" SeqB:"+seqB.charAt(realK-1)+ " Score2:"+score2 + " Score1:"+score1 +" TWO:"+S[i][k+1][j][l-1]);
						
			if (S[i][k][j][l] == score1) {
			    //System.out.println("ONE: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l);				
				i++;
				k--;
				j--;
				l++;
				
				continue;
			}
			if (S[i][k][j][l] == S[i][k+1][j][l-1] + gap ) {
			    //System.out.println("TWO: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l);
				realK++;
				k++;
				l--;
				continue;
			}
			//if (S[i][k][j][l] == (score2 + seq_score(seqA.charAt(i-1),seqB.charAt(realK-1)))){
			if (S[i][k][j][l] == (score2 + (seqA.charAt(i-1) == seqB.charAt(realK-1) ? seqw : 0))){	
			    //System.out.println("THREE: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l);
				int[] temp = new int[2];
			   	temp[0] = i; temp[1] = realK;
			   	match.add(temp); 
				realK++;
			   	i++; 
				j--; 
				continue;
			}

			//System.out.println("Score:"+ S[i][k][j][l]+" score1:"+score1+" W. gap:"+(S[i][k+1][j][l-1] + gap)+" Score2:"+score2+" CharA:"+seqA.charAt(i-1)+" CharB:"+seqB.charAt(realK-1));
			if ((i-realK) > delta){break;}
			if ((realK-i) > delta){realK++;
			k++;
			l--;
			continue;}
			//System.out.println("Score:"+ S[i][k][j][l]+" score1:"+score1+" W. gap:"+(S[i][k+1][j][l-1] + gap)+" Score2:"+score2+" CharA:"+seqA.charAt(i-1)+" CharB:"+seqB.charAt(realK-1));

			FOUND: for (int h=i+4; h <= realJ; h++) {
				if(sc1[i][h] == 0){
					continue;
				}
				for(int q=realK+4; q<=realL; q++){
					if(sc2[realK][q] == 0){
						continue;
					}		
					int relH = (h-(i+1));
					int relQ1 = ((q-1)-(realK+1))-(relH) + delta+1;
					int relQ2 = (q-(h+1)) + (2*delta+1);
					int relL2 = (delta+1)+(((realL)-(q+1))-(realJ - (h+1)));
					//System.out.println("FOUR: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l+" h:"+h+" q:"+q+" relH:"+relH+" relQ1:"+relQ1+" relQ2:"+relQ2+" relL2:"+relL2);
					if((i+1) > (h-1) || (realK+1) > (q-1) || relQ1 > (2*delta)+1 || relQ1 < -1){
						score1 = Math.abs(h-i+realK-q)*gap;
					}else{
						score1 = S[i+1][k][relH-1][relQ1+1];
					}
					
					if((h+1)>realJ || (q+1)>realL || Math.abs(q-h) > 2*delta || relL2 < 0 || relL2 > 2*delta+1){
						score2 = Math.abs(realJ-h+q-realL)*gap;
					}else{
						score2 = S[h+1][relQ2+1][j-(h-i)-1][relL2];
					}
					
					sm = nolog ? (2*(sc1[i][h]*sc2[realK][q])) : sc1[i][h]+sc2[realK][q];
					sm *= 100;
					int smInt = sm.intValue();
					smInt += score1 + score2; //!!! + (k-k)*gap;
					//System.out.println(i +" "+h+" "+realK+" "+q+" SM:"+sm+" Score1:"+score1+" Score2:"+score2+" Rela:"+S[i][k][j][l]);
					//System.out.println("FIVE: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l+" h:"+h+" q:"+q+" relH:"+relH+" relQ1:"+relQ1+" relQ2:"+relQ2+" relL2:"+relL2);
					//System.out.println("Score: "+score1 + " "+score2+" "+sc1[i][h]+" "+sc2[realK][q]+" "+sm);
					if (S[i][k][j][l] == smInt){
					    //System.out.println("FIVE: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l+" h:"+h+" q:"+q+" relH:"+relH+" relQ1:"+relQ1+" relQ2:"+relQ2);
						int[] temp = new int[4];
						temp[0] = i; temp[1] = h;
						temp[2] = realK; temp[3] = q;
						match.add(temp);
						track(i+1,k,relH-1,relQ1+1);				
						//System.out.println("BEFORE: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l+" h:"+h+" q:"+q+" relH:"+relH+" relQ1:"+relQ1+" relQ2:"+relQ2);
						i = h+1;
						realK = q+1;
						j = realJ - i;
						k = (2*delta+1) + (realK - i);
						l = (delta+1) + ((realL-realK)-(realJ-i));
						//System.out.println("AFTER: i:"+i+" realJ:"+realJ+" realK:"+realK+" realL:"+realL+" j:"+j+" k:"+k+" l:"+l+" h:"+h+" q:"+q+" relH:"+relH+" relQ1:"+relQ1+" relQ2:"+relQ2);
						found = true;
						break FOUND;
					}
				}
			}	
			if(!found){
				System.err.println("Backtrack failed at "+i+" "+realJ+" "+realK+" "+realL+ " SM:"+sm+ " Score:"+S[i][k][j][l]);	
				System.exit(1);
			}
		}
	}

	public ArrayList<int[]> getMatch(){
		return match;
	}
	
	public double seq_score(char a, char b){
		//int x = p.charToInt(a);
		//int y = p.charToInt(b);
		//return substitution[x][y];
		return seqw;
	}
}
