#include "file.h"
#include "phyl.h"

void usage(void);

int main(int argc, char **argv)
{
  FILE *fp;
  int read_error;   /* For keeping track of errors in reading entries */
  Phyl *phyl;
  CmdArg *cmdarg;   /* Command line arguments */
  char *s;          /* String for arguments */
  Entry *entry;

  cmdarg = InitArgument(argc, argv);

  while ((s = GetArgument(cmdarg)) != NULL) {
    usage();
    return 1;
  }

  if ((s = GetFilename(cmdarg)) == NULL)
    fp = stdin;
  else if ((fp = fopen(s, "r")) == NULL) {
    fprintf(stderr, "newick2col: Error in opening file '%s'\n", s);
    return 1; }

  printf("; Generated by newick2col\n");
  printf("; ========================================================================\n");
  
  InitConnect();

  while ((s = GetConnect(fp)) != NULL) {
    phyl = ReadPhyl(s, 1);

    entry = PhylEntry(phyl, "tree");

    PrintEntry(stdout, entry);
  }

  if (fp != stdin && fclose(fp) != 0) {
    fprintf(stderr, "stdpair: Error in closing file\n");
    return 1; }

  return 0;
}

void usage(void)
{
  fprintf(stderr,
	  "usage: newick2col [<file>]\n");
}
