#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;
use Errors;

# STDPAIR2
#
# Ebbe Sloth Andersen, Feb 2006.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries, $file, $header );

( $file ) = @ARGV;
( $header, $entries ) = &Formats::read_col ( $file );
&Errors::check_col ( $entries, { "TYPE" => ["RNA"] } );
$entries = &stdpair ( $entries );
$header .= "stdpair2 was run on this file.";
&Formats::write_col ( $header, $entries );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<

sub stdpair
{
    # Ebbe Sloth Andersen, July 2005.

    my ( $entries ) = @_;

    # Returns an array of hashes.

    my ( $entry, 
         @align_bp, 
         @residue, 
         $i, 
         $residue,
        );
    
    foreach $entry ( @{ $entries } ) {
	if ( $entry->{'TYPE'} eq "RNA" ) {
            @residue = ( );
            @align_bp = ( );
            @residue = split(/,/, $entry->{'residue'});
            @align_bp = split(/,/, $entry->{'align_bp'});
            foreach $residue ( @residue ) {
		$residue = uc($residue);
            }
            $i = 0;
            foreach $residue ( @residue ) {
		if ( $align_bp[$i] eq "." ) {
                    $residue = lc( $residue );
		} else {
                    
                    print Dumper ( @align_bp );
                    exit;

                    if ( $residue eq "A" && $residue[$align_bp[$i]-1] eq "U" ) {
                    } elsif ( $residue eq "U" && $residue[$align_bp[$i]-1] eq "A" ) {
                    } elsif ( $residue eq "G" && $residue[$align_bp[$i]-1] eq "C" ) {
                    } elsif ( $residue eq "C" && $residue[$align_bp[$i]-1] eq "G" ) {
                    } elsif ( $residue eq "G" && $residue[$align_bp[$i]-1] eq "U" ) {
                    } elsif ( $residue eq "U" && $residue[$align_bp[$i]-1] eq "G" ) {
                    } else {
                        $residue = lc( $residue );
                        $align_bp[$align_bp[$i]-1] = ".";
                        $align_bp[$i] = ".";
                    }
		}
		$i++;
            }
            $entry->{'residue'} = join(",", @residue);
            $entry->{'align_bp'} = join(",", @align_bp);
	}
    }
    return $entries;
}    
