package src;
import java.io.IOException;
import java.util.ArrayList;


public final class Pairwise {
	private int score = 0;
	private String seqA = null;
	private String seqB = null;
	private String strA = null;
	private String strB = null;
	
	/**
	 * @param args
	 * @throws IOException 
	 */
	public Pairwise(String fileA, String fileB, String outFile) throws IOException{
		ArrayList<int[]> match = null;
		final ReadBPMatrix bp = new ReadBPMatrix(fileA,fileB);
		final Parameters p = bp.getParameters();		
		seqA = p.getSeqA();
		seqB = p.getSeqB();
		
		if(GlobalParameters.mode == 2){
			final double[][] sc1 = p.getSc1();
			final double[][] sc2 = p.getSc2();
			//Since there are relatively few possible basepairings I trim the two-dimension basepairing matrix
			final ArrayList[] sc1trim = new ArrayList[p.getLengthA()+1];
			final ArrayList[] sc2trim = new ArrayList[p.getLengthB()+1];		
			for(int r=0; r<sc1.length; r++){
				final double[] temp = sc1[r];
				final ArrayList<double[]> ar = new ArrayList<double[]>();
				for(int s=0; s<temp.length; s++){
					if(sc1[r][s] > 0.0){
						final double[] temp2 = new double[2];
						temp2[0] = s; temp2[1] = sc1[r][s];
						ar.add(temp2);
						sc1trim[r] = ar;
					}
				}
			}
			for(int r=0; r<sc2.length; r++){
				final double[] temp = sc2[r];
				final ArrayList<double[]> ar = new ArrayList<double[]>();
				for(int s=0; s<temp.length; s++){
					if(sc2[r][s] > 0.0){
						final double[] temp2 = new double[2];
						temp2[0] = s; temp2[1] = sc2[r][s];
						ar.add(temp2);
						sc2trim[r] = ar;
					}
				}
			}
			p.setSc1trim(sc1trim);
			p.setSc2trim(sc2trim);
		}
		//pmcomp calculates the 4-dimensional scoring matrix
		MakeAlignment align;
		Backtrack bt;
		NewPM npm;
		String[] results;
		if(GlobalParameters.mode == 2){
			PmCompFast comp = new PmCompFast(p);
			score = (int)comp.initialize();
			bt = new BacktrackFast(p);
			match = bt.getMatch();
			align = new MakeAlignment(match,p,1,seqA.length(),1,seqB.length());
			results = align.getResults();
//			make a new basepairing probabilty matrix
			npm = new NewPM(results[0],results[2],p,1,1);
		}else if(GlobalParameters.mode == 1){
			PmCompLocal local = new PmCompLocal(p);
			int[] coord = local.initialize();
			local = null;
			PmCompNew comp = new PmCompNew(p);
			bt = comp.initialize(coord[0],coord[1],coord[2],coord[3]);
			match = bt.getMatch();
			align = new MakeAlignment(match,p,coord[0],coord[1],coord[2],coord[3]);
			results = align.getResults();
//			make a new basepairing probabilty matrix
			npm = new NewPM(results[0],results[2],p,coord[0],coord[2]);
		}else{
			PmCompNew comp = new PmCompNew(p);
			bt = comp.initialize(1,seqA.length(),1,seqB.length());
			score = comp.getScore();
			match = bt.getMatch();
			align = new MakeAlignment(match,p,1,seqA.length(),1,seqB.length());
			results = align.getResults();
//			make a new basepairing probabilty matrix
			npm = new NewPM(results[0],results[2],p,1,1);
		}
	
		seqA = results[0];
		strA = results[1];
		seqB = results[2];
		strB = results[3];
		//System.out.println(seqA+'\n'+strA+'\n'+seqB+'\n'+strB);		
		final double[][] pm = npm.getPm();
		new Output(pm,results[0],results[2], outFile);
		
		/*my $ngap = ($aseq =~ tr/-//);
		 $ngap += ($bseq =~ tr/-//);
		 print "recalculated score: ", $score+$ngap*$gap,"\n";*/
	}
	/**
	 * @return Returns the score.
	 */
	final public int getScore() {
		return score;
	}
	/**
	 * @return Returns the seqA.
	 */
	final public String getSeqA() {
		return seqA;
	}
	/**
	 * @return Returns the seqB.
	 */
	final public String getSeqB() {
		return seqB;
	}
	/**
	 * @return Returns the strA.
	 */
	final public String getStrA() {
		return strA;
	}
	/**
	 * @return Returns the strB.
	 */
	final public String getStrB() {
		return strB;
	}
}

