package src;

public final class ShortTermMemory {
	private ShortCell[][][][] STM;
	private ShortCell s = null;
	private int i_position = 0;
	private int j_position = 0;
	private short relI = 0;
	private short relJ = 0;
	private short relK = 0;
	private short relL = 0;
	private short delta = 0;
	private int offset = 0;
	private int j_dim = 0;
	private int k_dim = 0;
	private int l_dim = 0;
	private int diff;
	
	public ShortTermMemory(final short delta,final int diff){
		this.delta = delta;
		this.diff = diff;
	}
	//public void setPositions(int i_pos, int k_pos) {i_position = i_pos; k_position = k_pos;}
	public void set_I_Position(final int pos) {i_position = pos;}
	public void set_J_Position(final int pos) {j_position = pos;}
	public void setSTM(final int i_dim, final int j_dim, final int k_dim, final int l_dim){
		STM = new ShortCell[i_dim][j_dim][k_dim][l_dim];
		this.j_dim = j_dim;
		this.k_dim = k_dim;
		this.l_dim = l_dim;
		//System.out.println("Init: "+i_dim+" "+j_dim+" "+k_dim+" "+l_dim);
	}
	public void put(final int i, final int j, final int k, final int l, final int score, final char state, final short mbJ, final short mbL,final short[] mblPointer){
		final ShortCell scell = new ShortCell((short)score,state,mbJ,mbL,mblPointer);
		//Calculate the relative positions
		relI = (short) (i_position - i);
		relJ = (short) j;
		offset = (k-i)+diff;
		relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		STM[relI][relJ][relK][relL] = scell; 
		//System.out.println("Info: "+i+" "+j+" "+k+" "+l+" "+score+ " "+state+" "+mbJ+" "+mbL+" Pointer: "+mblPointer);
		//System.out.println("GetScoreRel: "+relI+" "+relJ+" "+relK+" "+relL);
	}
	public void putLocal(final int i, final int j, final int k, final int l, final int score, final char state){
		final ShortCell scell = new ShortCell((short)score,state);
		//Calculate the relative positions
		relI = (short) (i_position - i);
		relJ = (short) j;
		//offset = (k-i);
		//relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		STM[relI][relJ][k][relL] = scell; 
		//System.out.println("Info: "+i+" "+j+" "+k+" "+l+" "+score+ " "+state+" "+mbJ+" "+mbL+" Pointer: "+mblPointer);
		//System.out.println("GetScoreRel: "+relI+" "+relJ+" "+relK+" "+relL);
	}
	public int getScoreLocal(final int i, final int j, final int k, final int l){
		relI = (short)(i_position - i);
		relJ = (short)j;
		//offset = (k-i);
		//relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		if(STM[relI][relJ][k][relL] == null){
			return -1000000;
		}else{
			return STM[relI][relJ][k][relL].getScore();
		}
	}
	public ShortCell getCellLocal(final int i, final int j, final int k, final int l){
		relI = (short)(i_position - i);
		relJ = (short)j;
		//offset = (k-i);
		//relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		return STM[relI][relJ][k][relL];
	}
	public void putAll(final int i, final int j, final int k, final int l, final int score){
		final ShortCell scell = new ShortCell((short)score);
		//Calculate the relative positions
		relI = (short)(i - i_position);
		relJ = (short)(j - j_position);
		offset = (k-i)+diff;
		relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		STM[relI][relJ][relK][relL] = scell; 
	}
	public int getAll(final int i, final int j, final int k, final int l){
		relI = (short)(i - i_position);
		relJ = (short)(j - j_position);
		offset = (k-i)+diff;
		relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		if(STM[relI][relJ][relK][relL] == null){
			return -1000000;
		}else{
			return STM[relI][relJ][relK][relL].getScore();
		}
	}
	public ShortCell getCell(final int i, final int j, final int k, final int l){
		relI = (short)(i_position - i);
		relJ = (short)j;
		offset = (k-i)+diff;
		relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		return STM[relI][relJ][relK][relL];
	}
	public ShortCell getAllCell(final int i, final int j, final int k, final int l){
		relI = (short)(i - i_position);
		relJ = (short)(j - j_position);
		offset = (k-i)+diff;
		relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		return STM[relI][relJ][relK][relL];
	}
	public char getState(final int i, final int j, final int k, final int l){
		relI = (short)(i_position - i);
		relJ = (short)j;
		offset = (k-i)+diff;
		relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		//if(STM[relI][relJ][relK][relL] == null){
		//	return 'V';
		//}else{
			return STM[relI][relJ][relK][relL].getState();
		//}
	}
	public short[] getPointer(final int i, final int j, final int k, final int l){
		relI = (short)(i_position - i);
		relJ = (short)j;
		offset = (k-i)+diff;
		relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		if(STM[relI][relJ][relK][relL] == null){
			return null;
		}else{
			return STM[relI][relJ][relK][relL].getMblPointer();
		}
	}
	public int getScore(final int i, final int j, final int k, final int l){
		relI = (short)(i_position - i);
		relJ = (short)j;
		offset = (k-i)+diff;
		relK = (short)((delta+1) + offset);
		offset = (l-k) - (j-i);
		relL = (short)((delta+1)+offset);
		if(STM[relI][relJ][relK][relL] == null){
			return -1000000;
		}else{
			return STM[relI][relJ][relK][relL].getScore();
		}
	}
	public void transfer(){
		for(short j=0; j<j_dim;j++){
			for(short k=0; k<k_dim;k++){
				for(short l=0; l<l_dim;l++){
					s = STM[1][j][k][l];
					//if(s==null){
					//	STM[0][j][k][l] = null;
					//}else{
						STM[0][j][k][l] = s;//new ShortCell(s);
					//}
					STM[1][j][k][l] = null;
				}
			}
		}
		//STM[0] = STM[1];
		//STM[1] = new ShortCell[j_dim+1][k_dim][l_dim];
	}
}	
