#!/usr/bin/env perl   

#  -*- perl -*-

use strict;
use warnings FATAL => qw ( all );
use Data::Dumper;
use Formats;
use Errors;

# STDPAIR3
#
# Ebbe Sloth Andersen, 2007.

# >>>>>>>>>>>>>>>>>> RUN PROGRAM <<<<<<<<<<<<<<<<<<<<

my ( $entries, $file, $header );

( $file ) = @ARGV;
( $header, $entries ) = &Formats::read_col ( $file );
&Errors::check_col ( $entries, { "TYPE" => ["RNA"] } );
$entries = &T2U ( $entries );
$header .= "; T2U was run on this file.";
&Formats::write_col ( $header, $entries );

# >>>>>>>>>>>>>>>>>> SUBROUTINES <<<<<<<<<<<<<<<<<<<<<<<

sub T2U
{
    # Ebbe Sloth Andersen, May 2007.

    my ( $entries ) = @_;

    # Returns an array of hashes.

    my ( $entry, 
         @residue, 
         $residue,
         );
    
    foreach $entry ( @{ $entries } ) {
        if ( $entry->{'TYPE'} eq "RNA" ) {
            @residue = ( );
            @residue = split(/,/, $entry->{'residue'});
            foreach $residue ( @residue ) {
                $residue = lc($residue);
                if ( $residue eq "t" ) {
                    $residue = "u";
                }
            }
            $entry->{'residue'} = join(",", @residue);
        }
    }
    return $entries;
}
