package dk.kvl.alignmenttools.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.NoSuchElementException;

import dk.kvl.alignmenttools.Alignment;
import dk.kvl.sequencetools.SequenceAlphabet;

public class FastaReader extends BufferedReader implements AlignmentReader 
{
	
	private Alignment alignment = new Alignment();
	
	public FastaReader(File inFile) throws FileNotFoundException
	{
		super(new FileReader(inFile));
		readFile();
	}
	

	public Alignment getAlignment() {
		if (alignment.getPairingMask() != null)
        {
            alignment.updatePairings();
        }
        else
        {
            alignment.toLowerCase();
        }
        alignment.emptyInfo();
        return alignment;
	}
	
	protected void readFile()
	{
		String line = null;
		String title = null;
		StringBuffer sequence = null;
		try
		{
		while((line = readLine())!=null)
		{
			if(line.startsWith(">"))
			{
				if(title != null)
				{
					if(title.substring(0,4).equalsIgnoreCase("pair"))
					{
						alignment.addPairingMask(new dk.kvl.sequencetools.PairingMask(title,sequence.toString(),SequenceAlphabet.RNAALPHABET,true));
					}
					else
					{
						alignment.addSequence(new dk.kvl.sequencetools.Sequence(title,sequence.toString(),SequenceAlphabet.RNAALPHABET,true));
					}
				}
				sequence = new StringBuffer();
				title = line.substring(1,line.length());
			}
			else
			{
				sequence.append(line.trim());
			}
		}
		if(title.substring(0,4).equalsIgnoreCase("pair"))
		{
			alignment.addPairingMask(new dk.kvl.sequencetools.PairingMask(title,sequence.toString(),SequenceAlphabet.RNAALPHABET,true));
		}
		else
		{
			alignment.addSequence(new dk.kvl.sequencetools.Sequence(title,sequence.toString(),SequenceAlphabet.RNAALPHABET,true));
		}
		}
		catch(Exception e)
		{
			//????What????
			e.printStackTrace();
		}
	}
}
